/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.repr;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ReprMethod;

public class ReprLocalDate
implements ReprMethod {
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isApplicable(Object value) {
        return value instanceof LocalDate;
    }

    public String repr(Object value) {
        if (value == null) {
            return "NULL";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDate = ((LocalDate)value).format(dateTimeFormatter);
        return "DATE '" + formattedDate + "'";
    }

    public static void selfRegister() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        manager.addReprMethod((ReprMethod)new ReprLocalDate());
    }
}

