/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParametersBase;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCStoreProviderFactoryBase;
import org.gvsig.postgresql.dal.PostgreSQLHelper;
import org.gvsig.postgresql.dal.PostgreSQLStoreParameters;

public class PostgreSQLStoreProviderFactory
extends JDBCStoreProviderFactoryBase {
    private static final Set<String> ALLOWED_FUNCTIONS = new HashSet<String>(Arrays.asList("COUNT", "SUM", "MIN", "MAX"));
    private static final Set<String> DENIED_FUNCTIONS = Collections.EMPTY_SET;

    public PostgreSQLStoreProviderFactory() {
        super("PostgreSQL", "PostgreSQL store");
    }

    public JDBCStoreProvider createProvider(DataParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        PostgreSQLHelper helper = new PostgreSQLHelper((JDBCConnectionParameters)parameters);
        JDBCStoreProvider provider = helper.createProvider((JDBCStoreParameters)((JDBCStoreParametersBase)parameters), providerServices);
        return provider;
    }

    public JDBCStoreParametersBase createParameters() {
        PostgreSQLStoreParameters params = new PostgreSQLStoreParameters();
        return params;
    }

    public Function<String, Integer> allowFunction() {
        return name -> {
            if (ALLOWED_FUNCTIONS.contains(name)) {
                return 1;
            }
            if (DENIED_FUNCTIONS.contains(name)) {
                return 2;
            }
            return 0;
        };
    }

    public int allowGroupBy() {
        return 1;
    }

    public int hasVectorialSupport() {
        return 1;
    }

    public int hasRasterSupport() {
        return 2;
    }

    public int hasTabularSupport() {
        return 1;
    }

    public int hasSQLSupport() {
        return 1;
    }

    public int allowEditableFeatureType() {
        return 1;
    }
}

