/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.app.preparelayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.basepanel.AbstractButtonsPanel;

public class RasterProjectionActionsPanel
extends AbstractButtonsPanel {
    private static final long serialVersionUID = -3868504818382448187L;
    private JPanel buttonsPanel = null;
    private ButtonGroup group = new ButtonGroup();
    private JRadioButton changeViewProjection = null;
    private JRadioButton reproject = null;
    private JRadioButton ignoreRasterProjection = null;
    private JRadioButton notLoad = null;
    private JRadioButton onTheFly = null;
    private JCheckBox allfiles = null;
    private boolean layerIsReprojectable = true;
    private IProjection viewProj = null;
    private IProjection layerProj = null;

    public RasterProjectionActionsPanel(boolean layerIsReprojectable, String layerName, int defaultAction) {
        this(layerIsReprojectable, layerName, defaultAction, null, null);
    }

    public RasterProjectionActionsPanel(boolean layerIsReprojectable, String layerName, int defaultAction, IProjection viewProj, IProjection layerProj) {
        super(2);
        this.layerIsReprojectable = layerIsReprojectable;
        this.viewProj = viewProj;
        this.layerProj = layerProj;
        this.init(layerName);
        this.setSelection(defaultAction);
    }

    public void init(String lyrName) {
        BorderLayout bl = new BorderLayout();
        bl.setVgap(5);
        this.setLayout(bl);
        String msg = "";
        msg = this.viewProj != null && this.layerProj != null ? "<html><b>" + lyrName + "</b><BR><BR>" + Messages.getText((String)"dif_proj_with_projections") + "<BR>" + Messages.getText((String)"view_proj") + ": " + this.viewProj.getAbrev() + "<BR>" + Messages.getText((String)"layer_proj") + ": " + this.layerProj.getAbrev() + "</html>" : "<html><b>" + lyrName + "</b><BR><BR>" + Messages.getText((String)"dif_proj") + "</html>";
        this.add(new JLabel(msg), "North");
        this.add(this.getButtonsActionPanel(), "Center");
        this.add(this.getCheckOption(), "South");
    }

    private JPanel getButtonsActionPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"proj_options"), 0, 0, null, null));
            this.group.add(this.getIgnoreRasterProjectionButton());
            this.group.add(this.getChangeViewProjectionButton());
            this.group.add(this.getReprojectButton());
            this.group.add(this.getNotLoadButton());
            this.group.add(this.getOnTheFlyButton());
            this.buttonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 5, 5, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.buttonsPanel.add((Component)this.getIgnoreRasterProjectionButton(), gbc);
            gbc.gridy = 1;
            this.buttonsPanel.add((Component)this.getReprojectButton(), gbc);
            gbc.gridy = 2;
            this.buttonsPanel.add((Component)this.getChangeViewProjectionButton(), gbc);
            gbc.gridy = 3;
            this.buttonsPanel.add((Component)this.getNotLoadButton(), gbc);
            gbc.gridy = 4;
            this.buttonsPanel.add((Component)this.getOnTheFlyButton(), gbc);
        }
        return this.buttonsPanel;
    }

    private JRadioButton getChangeViewProjectionButton() {
        if (this.changeViewProjection == null) {
            this.changeViewProjection = new JRadioButton(Messages.getText((String)"change_view_proj"));
        }
        return this.changeViewProjection;
    }

    private JRadioButton getReprojectButton() {
        if (this.reproject == null) {
            this.reproject = new JRadioButton(Messages.getText((String)"reproject"));
            this.reproject.setEnabled(this.layerIsReprojectable);
        }
        return this.reproject;
    }

    private JRadioButton getIgnoreRasterProjectionButton() {
        if (this.ignoreRasterProjection == null) {
            this.ignoreRasterProjection = new JRadioButton(Messages.getText((String)"ignore_raster_proj"));
        }
        return this.ignoreRasterProjection;
    }

    private JRadioButton getNotLoadButton() {
        if (this.notLoad == null) {
            this.notLoad = new JRadioButton(Messages.getText((String)"not_load"));
        }
        return this.notLoad;
    }

    private JRadioButton getOnTheFlyButton() {
        if (this.onTheFly == null) {
            this.onTheFly = new JRadioButton(Messages.getText((String)"reproject_on_the_fly") + " (Not implemented yet)");
            this.onTheFly.setEnabled(false);
        }
        return this.onTheFly;
    }

    public int getSelection() {
        if (this.getChangeViewProjectionButton().isSelected()) {
            return 2;
        }
        if (this.getReprojectButton().isSelected()) {
            return 1;
        }
        if (this.getIgnoreRasterProjectionButton().isSelected()) {
            return 6;
        }
        if (this.getNotLoadButton().isSelected()) {
            return 4;
        }
        if (this.getOnTheFlyButton().isSelected()) {
            return 5;
        }
        return 6;
    }

    public void setSelection(int value) {
        if (value == 6) {
            this.getIgnoreRasterProjectionButton().setSelected(true);
        }
        if (value == 1) {
            this.getReprojectButton().setSelected(true);
        }
        if (value == 2) {
            this.getChangeViewProjectionButton().setSelected(true);
        }
        if (value == 4) {
            this.getNotLoadButton().setSelected(true);
        }
        if (value == 5) {
            this.getOnTheFlyButton().setSelected(true);
        }
    }

    public JCheckBox getCheckOption() {
        if (this.allfiles == null) {
            this.allfiles = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"apply_all"));
        }
        return this.allfiles;
    }
}

