/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jwizardcomponent.DefaultJWizardComponents;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportProcess;
import org.gvsig.export.Filter;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.swing.ExportSwingLocator;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.MessagePanel;
import org.gvsig.export.swing.impl.WizardOptionPanelAdapter;
import org.gvsig.export.swing.impl.panels.ExportProgressPanel;
import org.gvsig.export.swing.impl.panels.SelectFormatPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanels;
import org.gvsig.export.swing.spi.ExportPanelsFactory;
import org.gvsig.export.swing.spi.ExportPanelsManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.gui.beans.wizard.WizardPanel;
import org.gvsig.gui.beans.wizard.WizardPanelActionListener;
import org.gvsig.gui.beans.wizard.WizardPanelWithLogo;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJExportProcessPanel
extends JPanel
implements JExportProcessPanel,
WizardPanel {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJExportProcessPanel.class);
    private final ExportProcess process;
    private final Filter<ExportServiceFactory> serviceFilter;
    private final Set<JExportProcessPanel.ExportFinishListener> finishListeners;
    private WizardPanelWithLogo wizardPanel;
    private WizardPanelActionListener wizardListener;
    private int lastAction;

    public DefaultJExportProcessPanel(ExportProcess process, Filter<ExportServiceFactory> serviceFilter) {
        this.process = process;
        this.serviceFilter = serviceFilter;
        this.finishListeners = new HashSet<JExportProcessPanel.ExportFinishListener>();
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.wizardPanel = new WizardPanelWithLogo();
        this.addPanel(new SelectFormatPanel(this, this.process.getParameters(), this.serviceFilter, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExportProcessPanel.this.doAddPanels(((SelectFormatPanel)e.getSource()).getSelectedService());
            }
        }));
        this.setLayout(new BorderLayout());
        this.add((Component)this.wizardPanel, "Center");
        this.wizardPanel.setFinishButtonText(i18n.getTranslation("export"));
        this.wizardPanel.setWizardListener((WizardPanel)this);
        this.setWizardPanelActionListener(this.getWizardPanelActionListener());
        this.wizardPanel.setNextButtonEnabled(false);
        this.wizardPanel.setFinishButtonEnabled(false);
        this.setPreferredSize(new Dimension(600, 350));
    }

    private void addPanel(ExportPanel panel) {
        WizardOptionPanelAdapter optionPanel = new WizardOptionPanelAdapter(this, panel);
        this.wizardPanel.addOptionPanel((OptionPanel)optionPanel);
    }

    private void doAddPanels(ExportServiceFactory serviceFactory) {
        try {
            this.removePreviousPanels();
            if (this.process.getParameters() != null) {
                if (!StringUtils.equals((CharSequence)this.process.getParameters().getServiceName(), (CharSequence)serviceFactory.getName())) {
                    this.process.setOutputFormat(serviceFactory.getName());
                }
            } else if (this.process.getParameters() == null) {
                this.process.setOutputFormat(serviceFactory.getName());
            }
            ExportParameters parameters = this.process.getParameters();
            ExportPanelsManager panelsManager = ExportSwingLocator.getExportPanelsManager();
            ExportPanelsFactory panelsFactory = panelsManager.getPanelsFactory(serviceFactory.getName());
            ExportPanels panels = panelsFactory.createPanels((JExportProcessPanel)this, parameters);
            for (ExportPanel panel : panels) {
                this.addPanel(panel);
            }
            if (parameters.needsSelectTargetProjection() && !panels.contains("PANEL_SELECT_TARGET_PROJECTION")) {
                this.addPanel(panelsManager.createStandardPanel("PANEL_SELECT_TARGET_PROJECTION", (JExportProcessPanel)this, parameters, new Object[0]));
            }
            if (!panels.contains("PANEL_SELECT_EXPORT_FILTER")) {
                this.addPanel(panelsManager.createStandardPanel("PANEL_SELECT_EXPORT_FILTER", (JExportProcessPanel)this, parameters, new Object[0]));
            }
            this.addPanel(new ExportProgressPanel(this, parameters));
        }
        catch (ExportException ex) {
            LOG.warn("Can't add panels to wizard.", (Throwable)ex);
            this.showError((Exception)((Object)ex));
        }
    }

    public ExportProcess getProcess() {
        return this.process;
    }

    public ExportParameters getParameters() {
        return this.process.getParameters();
    }

    public void setWizardPanelActionListener(WizardPanelActionListener wizardListener) {
        this.wizardListener = wizardListener;
    }

    public WizardPanelActionListener getWizardPanelActionListener() {
        if (this.wizardListener == null) {
            this.wizardListener = new WizardPanelActionListener(){

                public void finish(WizardPanel wizardPanel) {
                    DefaultJExportProcessPanel.this.doExport();
                }

                public void cancel(WizardPanel wizardPanel) {
                    DefaultJExportProcessPanel.this.doCancel();
                }
            };
        }
        return this.wizardListener;
    }

    private void removePreviousPanels() {
        DefaultJWizardComponents wizardComponents = this.wizardPanel.getWizardComponents();
        for (int i = wizardComponents.getWizardPanelList().size() - 1; i >= 1; --i) {
            wizardComponents.removeWizardPanel(i);
        }
    }

    private void lastWizard() {
        this.wizardPanel.getWizardComponents().getNextButton().getActionListeners()[0].actionPerformed(null);
    }

    private void showError(Exception e) {
        Feature f = null;
        if (e instanceof ExportException) {
            f = ((ExportException)((Object)e)).getFeature();
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        MessagePanel.showMessage(i18nManager.getTranslation("_Warning"), i18nManager.getTranslation("_There_have_been_problems_exporting_data"), e, f);
    }

    public void addFinishListener(JExportProcessPanel.ExportFinishListener finishListener) {
        this.finishListeners.add(finishListener);
    }

    private void fireCancelled() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultJExportProcessPanel.this.fireCancelled();
                }
            });
        }
        for (JExportProcessPanel.ExportFinishListener listener : this.finishListeners) {
            try {
                listener.cancelled((JExportProcessPanel)this);
            }
            catch (Exception exception) {}
        }
    }

    private void fireFinished() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultJExportProcessPanel.this.fireFinished();
                }
            });
            return;
        }
        for (JExportProcessPanel.ExportFinishListener listener : this.finishListeners) {
            try {
                listener.finished((JExportProcessPanel)this);
            }
            catch (Exception exception) {}
        }
    }

    private void doCancel() {
        this.setVisible(false);
        this.fireCancelled();
    }

    private void doExport() {
        this.lastWizard();
        ExportParameters params = this.process.getParameters();
        ExportManager exportManager = ExportLocator.getManager();
        ExportParameters copyParams = null;
        try {
            copyParams = params.clone();
            copyParams.setCreationDate(new Date());
            History h = exportManager.getHistory();
            h.add((Object)copyParams);
        }
        catch (Exception ex) {
            LOG.warn("Not able to create a clone object for export parameters", (Throwable)ex);
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultJExportProcessPanel.this.process.run();
                    DefaultJExportProcessPanel.this.doProcessFinished();
                }
                catch (Exception ex) {
                    LOG.warn("Can't export", (Throwable)ex);
                    DefaultJExportProcessPanel.this.showError(ex);
                }
            }
        }, "exportProcess");
        th.start();
    }

    private void doProcessFinished() {
        this.fireFinished();
        this.setButtonText(3, ToolsLocator.getI18nManager().getTranslation("_Close"));
    }

    public JComponent asJComponent() {
        return this;
    }

    private JButton getButton(int button) {
        switch (button) {
            case 0: {
                return this.wizardPanel.getWizardComponents().getBackButton();
            }
            case 1: {
                return this.wizardPanel.getWizardComponents().getNextButton();
            }
            case 2: {
                return this.wizardPanel.getWizardComponents().getFinishButton();
            }
            case 3: {
                return this.wizardPanel.getWizardComponents().getCancelButton();
            }
        }
        throw new IllegalArgumentException("Illegal button value (" + button + ").");
    }

    public void setButtonEnabled(int button, boolean enabled) {
        this.getButton(button).setEnabled(enabled);
    }

    public void setButtonText(int button, String text) {
        this.getButton(button).setText(text);
    }

    public boolean isButtonEnabled(int button) {
        return this.getButton(button).isEnabled();
    }

    public String getButtonText(int button) {
        return this.getButton(button).getText();
    }

    public void setLastAcction(int action) {
        this.lastAction = action;
    }

    public int getLastAction() {
        return this.lastAction;
    }

    public void nextPanel() {
        this.wizardPanel.doAction(1);
    }

    public void previousPanel() {
        this.wizardPanel.doAction(0);
    }
}

