/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectGeometryFieldPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class SelectGeometryFieldPanel
extends SelectGeometryFieldPanelView
implements ExportPanel {
    private final ExportParametersGeometry parameters;
    private final JExportProcessPanel processPanel;

    public SelectGeometryFieldPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportParametersGeometry)parameters;
        this.initComponents();
    }

    public String getIdPanel() {
        return "PANEL_SELECT_GEOMETRY_FIELD";
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Selection_of_geometry_field");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        String geometryFieldName = this.getGeometryField();
        this.parameters.setSourceGeometryFieldName(geometryFieldName);
        FeatureType ft = this.parameters.getExportAttributes().getTargetFeatureType();
        FeatureAttributeDescriptor descriptor = ft.getAttributeDescriptor(geometryFieldName);
        if (descriptor != null) {
            GeometryType gt = descriptor.getGeomType();
            this.parameters.setTargetGeometryType(gt.getType());
            this.parameters.setTargetGeometrySubtype(gt.getSubType());
        }
    }

    public void enterPanel() {
        String geometryField = this.parameters.getSourceGeometryFieldName();
        if (geometryField != null) {
            String defaultGeomName = this.parameters.getSourceFeatureType().getDefaultGeometryAttributeName();
            if (this.parameters.getSourceGeometryFieldName() == null ? defaultGeomName == null : this.parameters.getSourceGeometryFieldName().equals(defaultGeomName)) {
                this.rdoUseTheGeometryFieldByDefault.setSelected(true);
            } else {
                this.rdoSelectTheFieldToBeUsedAsGeometry.setSelected(true);
                String toCheck = this.parameters.getSourceGeometryFieldName();
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.cboGeometryField.getModel();
                if (model.getIndexOf(toCheck) != -1) {
                    this.cboGeometryField.getModel().setSelectedItem(this.parameters.getSourceGeometryFieldName());
                }
            }
        } else {
            this.rdoUseNullAsTheValueOfTheGeometry.setSelected(true);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.rdoSelectTheFieldToBeUsedAsGeometry.setEnabled(true);
        this.rdoSelectTheFieldToBeUsedAsGeometry.setSelected(false);
        if (this.parameters.getSourceGeometryFieldName() == null) {
            this.rdoUseTheGeometryFieldByDefault.setEnabled(false);
            this.rdoUseTheGeometryFieldByDefault.setSelected(false);
            this.rdoUseNullAsTheValueOfTheGeometry.setSelected(true);
        } else {
            this.rdoUseTheGeometryFieldByDefault.setEnabled(true);
            this.rdoUseTheGeometryFieldByDefault.setSelected(true);
            this.rdoUseNullAsTheValueOfTheGeometry.setSelected(false);
        }
        ArrayList<String> items = new ArrayList<String>();
        for (ExportAttributes.ExportAttribute exportAttribute : this.parameters.getExportAttributes()) {
            items.add(exportAttribute.getName());
        }
        items.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String item : items) {
            model.addElement(item);
        }
        this.cboGeometryField.setModel(model);
        this.cboGeometryField.setEnabled(false);
        this.rdoSelectTheFieldToBeUsedAsGeometry.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectGeometryFieldPanel.this.cboGeometryField.setEnabled(SelectGeometryFieldPanel.this.rdoSelectTheFieldToBeUsedAsGeometry.isSelected());
            }
        });
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        i18nc.translate(this.lblSelectOfTheGeometryField);
        i18nc.translate((AbstractButton)this.rdoSelectTheFieldToBeUsedAsGeometry);
        i18nc.translate((AbstractButton)this.rdoUseNullAsTheValueOfTheGeometry);
        i18nc.translate((AbstractButton)this.rdoUseTheGeometryFieldByDefault);
    }

    public String getGeometryField() {
        if (this.rdoUseNullAsTheValueOfTheGeometry.isSelected()) {
            return null;
        }
        if (this.rdoUseTheGeometryFieldByDefault.isSelected()) {
            return this.parameters.getSourceFeatureType().getDefaultGeometryAttribute().getName();
        }
        return (String)this.cboGeometryField.getSelectedItem();
    }
}

