/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersFile;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectOutputFilePanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;

public class SelectOutputFilePanel
extends SelectOutputFilePanelView
implements ExportPanel {
    private FilePickerController fileController;
    private final ExportParametersFile parameters;
    private final JExportProcessPanel processPanel;

    public SelectOutputFilePanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportParametersFile)parameters;
        this.initComponents();
    }

    public String getIdPanel() {
        return "PANEL_SELECT_OUTPUT_FILE";
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("Seleccionar_fichero");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        int resp;
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        if (this.fileController.isEmpty()) {
            throw new ExportPanelValidationException(i18n.getTranslation("_File_cannot_be_empty"));
        }
        File file = (File)this.fileController.get();
        File newFile = null;
        try {
            newFile = ExpressionUtils.evaluateFilename((File)file);
        }
        catch (Exception ex) {
            throw new ExportPanelValidationException(i18n.getTranslation("_Evaluated_file_path_is_not_valid"));
        }
        return newFile == null || !newFile.exists() || (resp = dialogs.confirmDialog(i18n.getTranslation("fichero_ya_existe_seguro_desea_guardarlo"), i18n.getTranslation("guardar"), 0, 3, "OverwriteFileOnExport")) != 1;
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        File file = (File)this.fileController.get();
        this.parameters.setFile(file);
    }

    public void enterPanel() {
        File file = this.parameters.getFile();
        if (file != null) {
            this.fileController.set((Object)file);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        File initialPath = null;
        if (this.parameters.getFile() != null) {
            initialPath = this.parameters.getFile();
        }
        this.fileController = ToolsSwingLocator.getToolsSwingManager().createFilePickerController((JTextComponent)this.txtFile, this.btnSelectFile, null, null, initialPath, true);
        JPopupMenu menu = this.txtFile.getComponentPopupMenu();
        menu.add(expressionSwingManager.createJExpressionBuilderAction((JTextComponent)this.txtFile));
        menu.add(expressionSwingManager.createUniqueTemporalFileAction((JTextComponent)this.txtFile, (Pair)new Pair<String, String>(){

            public String getLeft() {
                try {
                    return ((ExportParameters)SelectOutputFilePanel.this.parameters).getSourceFeatureStore().getName();
                }
                catch (Exception ex) {
                    return "temp";
                }
            }

            public String getRight() {
                return SelectOutputFilePanel.this.parameters.getFileExtension();
            }

            public String setValue(String value) {
                return null;
            }
        }));
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        i18nc.translate(this.lblFile);
    }
}

