/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.ResultSet;

import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;
import org.jzkit.search.provider.iface.Condition;
import org.jzkit.search.provider.iface.Diagnostic;
import org.jzkit.search.provider.iface.DiagnosticEvent;
import org.jzkit.search.provider.iface.IRQuery;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;
import org.jzkit.search.util.ResultSet.RSStatusMaskCondition;
import org.jzkit.search.util.ResultSet.ResultSetEvent;

public abstract class AbstractIRResultSet
extends Observable {
    public static final int TASK_MESSAGE_ERROR = 1;
    public static final int TASK_MESSAGE_WARNING = 2;
    public static final int TASK_MESSAGE_INFO = 2;
    public static final int TASK_MESSAGE_DIAGNOSTIC = 2;
    protected int task_status_code = 0;
    protected String task_identifier = null;
    protected String result_set_name = null;
    protected Object user_data = null;
    protected IRQuery query = null;
    protected long create_time = System.currentTimeMillis();
    protected OIDRegisterEntry requestedSyntax = null;
    protected String requestedSyntaxName = null;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public AbstractIRResultSet() {
        this.task_identifier = "" + this.hashCode();
    }

    public AbstractIRResultSet(Observer[] observers) {
        this(null, observers);
    }

    public AbstractIRResultSet(String task_identifier) {
        this(task_identifier, null);
    }

    public AbstractIRResultSet(String task_identifier, Observer[] observers) {
        this.task_identifier = task_identifier != null ? task_identifier : "" + this.hashCode();
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                this.addObserver(observers[i]);
            }
            ResultSetEvent e = new ResultSetEvent(1000, null);
            this.setChanged();
            this.notifyObservers(e);
        }
    }

    public OIDRegisterEntry getRequestedSyntax() {
        return this.requestedSyntax;
    }

    public void setRequestedSyntax(OIDRegisterEntry rs) {
        this.requestedSyntax = rs;
    }

    public String getRequestedSyntaxName() {
        return this.requestedSyntaxName;
    }

    public void setRequestedSyntaxName(String rsn) {
        this.requestedSyntaxName = rsn;
    }

    public String getSetID() {
        return this.task_identifier;
    }

    public int getStatus() {
        return this.task_status_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int task_status_code) {
        this.log.fine("Set result set state to " + task_status_code);
        AbstractIRResultSet abstractIRResultSet = this;
        synchronized (abstractIRResultSet) {
            this.task_status_code = task_status_code;
            this.notifyAll();
        }
        ResultSetEvent e = new ResultSetEvent(1011, new Integer(task_status_code));
        this.setChanged();
        this.notifyObservers(e);
    }

    public void setDiagnosticStatus(String status_code, String target_name, String addinfo) {
        Diagnostic the_diagnostic = new Diagnostic(status_code, target_name, addinfo);
        DiagnosticEvent e = new DiagnosticEvent(the_diagnostic);
        this.setChanged();
        this.notifyObservers(e);
    }

    public boolean waitForStatus(int status, long timeout) throws IRResultSetException {
        return this.waitForCondition(new RSStatusMaskCondition(status), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCondition(Condition condition, long timeout) throws IRResultSetException {
        long endtime = 0L;
        long remain = timeout;
        boolean result = false;
        if (timeout > 0L) {
            endtime = System.currentTimeMillis() + timeout;
        }
        while (!((result = condition.evaluate(this)) || endtime != 0L && System.currentTimeMillis() >= endtime)) {
            try {
                AbstractIRResultSet abstractIRResultSet = this;
                synchronized (abstractIRResultSet) {
                    this.wait(remain);
                }
            }
            catch (InterruptedException ie) {
                if (timeout <= 0L) continue;
                remain = endtime - System.currentTimeMillis() + 10L;
            }
            finally {
                Thread.currentThread();
                Thread.yield();
            }
        }
        return result;
    }

    public int getPrivateTaskStatusCode() {
        return -1;
    }

    public String lookupPrivateStatusCode(int code) {
        return "Unknown";
    }

    public void cancelTask() {
    }

    public void setQuery(IRQuery query) {
        this.query = query;
    }

    public IRQuery getQuery() {
        return this.query;
    }

    public long getTaskCreationTime() {
        return this.create_time;
    }

    public void destroyTask() {
        this.deleteObservers();
    }

    public void requestStatusNotification() {
        ResultSetEvent e = new ResultSetEvent(1005, new Integer(this.task_status_code));
        this.setChanged();
        this.notifyObservers(e);
    }

    public void setResultSetName(String result_set_name) {
        this.result_set_name = result_set_name;
    }

    public String getResultSetName() {
        return this.result_set_name;
    }

    public abstract void asyncGetFragment(int var1, int var2, RecordFormatSpecification var3, IFSNotificationTarget var4) throws IRResultSetException;

    public abstract int getFragmentCount();

    public abstract int getRecordAvailableHWM();

    public abstract void close();

    public abstract IRResultSetInfo getResultSetInfo();
}

