/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.h2spatial.backup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.h2spatial.backup.BackupView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backup
extends BackupView {
    private static final Logger LOGGER = LoggerFactory.getLogger(Backup.class);
    private PickerController<JDBCServerExplorerParameters> pickerConnection;
    private FilePickerController pickerFile;

    public Backup() {
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.pickerConnection = dataSwingManager.createJDBCConnectionPickerController(this.cboConnection, this.btnConnection);
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.pickerFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtFile, this.btnFile);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblConnection);
        toolsSwingManager.translate(this.lblFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBackup() {
        block25: {
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            InputStreamReader reader = null;
            BufferedReader breader = null;
            try {
                JDBCServerExplorerParameters connection = (JDBCServerExplorerParameters)this.pickerConnection.get();
                if (!connection.getProviderName().equals("H2Spatial")) {
                    application.messageDialog(i18n.getTranslation("_Only_H2Spatial_database_backups_can_be_created"), i18n.getTranslation("_Backup"), 1);
                    return;
                }
                File file = (File)this.pickerFile.get();
                File tmpFile = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + ".tmp");
                DataManager dataManager = DALLocator.getDataManager();
                JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(connection.getProviderName(), (DataServerExplorerParameters)connection);
                explorer.execute("SCRIPT TO '" + tmpFile.getAbsolutePath().replace("\\", "/") + "' CHARSET '" + StandardCharsets.UTF_8.name() + "'");
                try (FileWriterWithEncoding writer = new FileWriterWithEncoding(file, StandardCharsets.UTF_8);){
                    String line;
                    reader = new InputStreamReader((InputStream)new FileInputStream(tmpFile), StandardCharsets.UTF_8);
                    breader = new BufferedReader(reader, 8192);
                    ArrayList<String> linesToMove = new ArrayList<String>();
                    while ((line = breader.readLine()) != null) {
                        if (linesToMove != null && line.startsWith("CREATE DOMAIN ")) {
                            linesToMove.add(line);
                            continue;
                        }
                        if (linesToMove != null && line.startsWith("CREATE FORCE VIEW PUBLIC.GEOMETRY_COLUMNS")) {
                            for (String str : linesToMove) {
                                writer.write(str);
                                writer.write("\n");
                            }
                            linesToMove = null;
                        }
                        writer.write(line);
                        writer.write("\n");
                    }
                }
                FileUtils.deleteQuietly((File)tmpFile);
                IOUtils.closeQuietly((Reader)breader);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't create backup.", (Throwable)ex);
                application.messageDialog(i18n.getTranslation("_Cant_create_backup") + "\n\n" + i18n.getTranslation("_see_error_log_for_more_information"), i18n.getTranslation("_Backup"), 2);
                break block25;
            }
            finally {
                IOUtils.closeQuietly(breader);
                IOUtils.closeQuietly(reader);
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

