/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Properties;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.exceptions.ParserCreationException;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerCreationException;
import org.gvsig.gpe.lib.api.parser.IGPEContentHandler;
import org.gvsig.gpe.lib.api.parser.IGPEContentHandlerInmGeom;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandler;
import org.gvsig.gpe.lib.impl.parser.GPEContentHandlerAdapter;
import org.gvsig.gpe.lib.impl.writer.GPEWriterHandler;
import org.gvsig.gpe.lib.spi.GPEProviderLocator;
import org.gvsig.gpe.lib.spi.GPEProviderManager;
import org.gvsig.gpe.lib.spi.parser.IGPEParser;

public class DefaultGPEManager
implements GPEManager {
    private GPEProviderManager gpeProviderManager = null;
    private Properties properties = new Properties();

    public Iterator getKeys() {
        return this.properties.keySet().iterator();
    }

    public String getStringProperty(String key) {
        Object obj = this.getProperty(key);
        if (obj == null) {
            return null;
        }
        return (String)obj;
    }

    public int getIntPropertyProperty(String key) {
        Object obj = this.getProperty(key);
        if (obj == null) {
            return -1;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public boolean getBooleanProperty(String key) {
        Object obj = this.getProperty(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public IGPEWriterHandler createWriter(String name) throws WriterHandlerCreationException {
        return new GPEWriterHandler(this.getGPEProviderManager().createWriterHandlerImplementor(name));
    }

    public IGPEWriterHandler createWriterByClass(String prefferredImplClassName) throws WriterHandlerCreationException {
        return new GPEWriterHandler(this.getGPEProviderManager().createWriterHandlerImplementorByClass(prefferredImplClassName));
    }

    public IGPEWriterHandler createWriterByMimeType(String mimeType) throws WriterHandlerCreationException {
        return new GPEWriterHandler(this.getGPEProviderManager().createWriterHandlerImplementorByMimeType(mimeType));
    }

    public void parse(IGPEContentHandler contents, IGPEErrorHandler errors, URI uri) throws ParserCreationException {
        IGPEParser parser = this.getGPEProviderManager().createParser(uri);
        parser.parse((IGPEContentHandlerInmGeom)new GPEContentHandlerAdapter(contents), errors, uri);
    }

    private GPEProviderManager getGPEProviderManager() {
        if (this.gpeProviderManager == null) {
            this.gpeProviderManager = GPEProviderLocator.getGPEProviderManager();
        }
        return this.gpeProviderManager;
    }

    public void parse(IGPEContentHandler contents, IGPEErrorHandler errors, File file) throws ParserCreationException {
        IGPEParser parser = this.getGPEProviderManager().createParser(file);
        try {
            parser.parse((IGPEContentHandlerInmGeom)new GPEContentHandlerAdapter(contents), errors, (InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new ParserCreationException((Throwable)e);
        }
    }

    public boolean accept(URI uri) {
        return this.getGPEProviderManager().accept(uri);
    }

    public void parse(IGPEContentHandlerInmGeom contents, IGPEErrorHandler errors, URI uri) throws ParserCreationException {
        IGPEParser parser = this.getGPEProviderManager().createParser(uri);
        parser.parse(contents, errors, uri);
    }

    public void parse(IGPEContentHandlerInmGeom contents, IGPEErrorHandler errors, File file) throws ParserCreationException {
        IGPEParser parser = this.getGPEProviderManager().createParser(file);
        try {
            parser.parse(contents, errors, (InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new ParserCreationException((Throwable)e);
        }
    }

    public String getDefaultProjection(File file) throws ParserCreationException {
        try {
            IGPEParser parser = this.getGPEProviderManager().createParser(file);
            return parser.getProjection();
        }
        catch (ParserCreationException e) {
            throw new ParserCreationException((Throwable)e);
        }
    }
}

