/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.dbf.DBFFeatureWriter;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.SHPFileWrite;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPFeatureWriter
extends DBFFeatureWriter {
    private static final GeometryManager GEOM_MANAGER = GeometryLocator.getGeometryManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(SHPFeatureWriter.class);
    private SHPFileWrite shpWrite;
    private Envelope envelope = null;
    private int[] supportedGeometryTypes;
    private int fileSize;
    private FeatureType shpFeatureType;

    protected SHPFeatureWriter(String name) {
        super(name);
    }

    public void begin(DBFStoreParameters dbfParameters, FeatureType featureType, long numRows) throws DataException {
        SHPStoreParameters shpParameters = (SHPStoreParameters)dbfParameters;
        File shpFile = shpParameters.getSHPFile();
        File shxFile = shpParameters.getSHXFile();
        FileChannel shpChannel = null;
        FileChannel shxChannel = null;
        try {
            shpChannel = (FileChannel)SHPFeatureWriter.getWriteChannel((String)shpFile.getAbsolutePath());
            shxChannel = (FileChannel)SHPFeatureWriter.getWriteChannel((String)shxFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new WriteException(this.name, (Throwable)e);
        }
        this.shpWrite = new SHPFileWrite(shpChannel, shxChannel);
        int shapeType = this.getShapeTypeAndSetSupportedGeometries(featureType);
        try {
            this.shpWrite.writeHeaders(GEOM_MANAGER.createEnvelope(0.0, 0.0, 0.0, 0.0, featureType.getDefaultGeometryAttribute().getGeomType().getSubType()), shapeType, 0, 0);
        }
        catch (CreateEnvelopeException e) {
            LOGGER.warn("Error creating the envelope", (Throwable)e);
        }
        this.shpFeatureType = featureType;
        EditableFeatureType efType = featureType.getEditable();
        efType.remove(efType.getDefaultGeometryAttributeIndex());
        efType.setDefaultGeometryAttributeName(null);
        super.begin(dbfParameters, (FeatureType)efType, numRows);
    }

    private int getShapeTypeAndSetSupportedGeometries(FeatureType featureType) {
        int gvSIG_geometrySubType;
        int gvSIG_geometryType;
        FeatureAttributeDescriptor geometryAttr = featureType.getAttributeDescriptor(featureType.getDefaultGeometryAttributeIndex());
        try {
            GeometryType geomType = geometryAttr.getGeomType();
            gvSIG_geometryType = geomType.getType();
            gvSIG_geometrySubType = geomType.getSubType();
        }
        catch (Exception e) {
            gvSIG_geometryType = geometryAttr.getGeometryType();
            gvSIG_geometrySubType = geometryAttr.getGeometrySubType();
        }
        this.setSupportedGeometryTypes(gvSIG_geometryType);
        int shapeType = 0;
        shapeType = this.shpWrite.getShapeType(gvSIG_geometryType, gvSIG_geometrySubType);
        return shapeType;
    }

    public void dispose() {
        super.dispose();
        this.envelope = null;
        this.shpWrite = null;
    }

    public void end() throws DataException {
        try {
            if (this.envelope == null) {
                try {
                    this.envelope = GEOM_MANAGER.createEnvelope(0.0, 0.0, 0.0, 0.0, 0);
                }
                catch (CreateEnvelopeException e) {
                    LOGGER.error("Error creating the envelope", (Throwable)e);
                }
            }
            int shapeType = this.getShapeTypeAndSetSupportedGeometries(this.shpFeatureType);
            this.shpWrite.writeHeaders(this.envelope, shapeType, super.getRowCount(), this.shpWrite.size());
            super.end();
            this.shpWrite.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't write SHP file.", e);
        }
    }

    public void append(Feature feature) throws DataException {
        Geometry theGeom = feature.getDefaultGeometry();
        if (theGeom != null) {
            if (!this.canWriteGeometry(theGeom.getType())) {
                throw new WriteException(this.name, (Throwable)new RuntimeException("UnsupportedGeometryType: " + theGeom.getGeometryType().getName()));
            }
            super.append(feature);
            this.fileSize = this.shpWrite.writeIGeometry(theGeom);
            Envelope envelope = theGeom.getEnvelope();
            if (envelope != null) {
                if (this.envelope != null) {
                    this.envelope.add(envelope);
                } else {
                    this.envelope = envelope;
                }
            }
        } else {
            super.append(feature);
            this.fileSize = this.shpWrite.writeIGeometry(theGeom);
        }
    }

    private void setSupportedGeometryTypes(int gvSIG_geometryType) {
        if (GeometryUtils.isSubtype((int)1, (int)gvSIG_geometryType)) {
            this.supportedGeometryTypes = new int[]{1, 16};
            return;
        }
        if (GeometryUtils.isSubtype((int)7, (int)gvSIG_geometryType)) {
            this.supportedGeometryTypes = new int[]{7, 16};
            return;
        }
        if (GeometryUtils.isSubtype((int)2, (int)gvSIG_geometryType)) {
            this.supportedGeometryTypes = new int[]{8, 2, 16};
            return;
        }
        if (GeometryUtils.isSubtype((int)8, (int)gvSIG_geometryType)) {
            this.supportedGeometryTypes = new int[]{8, 2, 16};
            return;
        }
        if (GeometryUtils.isSubtype((int)3, (int)gvSIG_geometryType)) {
            this.supportedGeometryTypes = new int[]{9, 3, 16};
            return;
        }
        if (GeometryUtils.isSubtype((int)9, (int)gvSIG_geometryType)) {
            this.supportedGeometryTypes = new int[]{9, 3, 16};
            return;
        }
        this.supportedGeometryTypes = new int[0];
    }

    public boolean canWriteGeometry(int gvSIGgeometryType) {
        for (int i = 0; i < this.supportedGeometryTypes.length; ++i) {
            if (!GeometryUtils.isSubtype((int)this.supportedGeometryTypes[i], (int)gvSIGgeometryType)) continue;
            return true;
        }
        return false;
    }
}

