/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.ISHPFile;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.ShapeFileHeader2;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.PointGeometryType;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.utils.bigfile.BigByteBuffer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPFile
implements ISHPFile {
    private static final Logger logger = LoggerFactory.getLogger(SHPFile.class);
    private Envelope extent;
    private int type;
    private int subType;
    private String srsParameters;
    private FileInputStream fin;
    private FileChannel channel;
    private BigByteBuffer2 bb;
    private FileInputStream finShx;
    private FileChannel channelShx;
    private BigByteBuffer2 bbShx;
    private SHPStoreParameters params;
    private int[] supportedGeometryTypes;
    private final GeometryManager gManager = GeometryLocator.getGeometryManager();
    private GeometryType gtypeNull;
    private PointGeometryType gtypePoint2D;
    private GeometryType gtypeCurve2D;
    private GeometryType gtypeSurface2D;
    private GeometryType gtypeMultiPoint2D;
    private boolean useNullGeometry = false;

    public SHPFile(SHPStoreParameters params) {
        this.params = params;
        try {
            this.gtypeNull = this.gManager.getGeometryType(16, 0);
            this.gtypePoint2D = (PointGeometryType)this.gManager.getGeometryType(1, 0);
            this.gtypeCurve2D = this.gManager.getGeometryType(2, 0);
            this.gtypeSurface2D = this.gManager.getGeometryType(3, 0);
            this.gtypeMultiPoint2D = this.gManager.getGeometryType(7, 0);
        }
        catch (GeometryTypeNotSupportedException e) {
            throw new RuntimeException("Unable to get the 2D geometry types to use", e);
        }
        catch (GeometryTypeNotValidException e) {
            throw new RuntimeException("Unable to get the 2D geometry types to use", e);
        }
    }

    @Override
    public void setUseNullGeometry(boolean useNullGeometry) {
        this.useNullGeometry = useNullGeometry;
    }

    @Override
    public void close() throws CloseException {
        CloseException ret = null;
        try {
            this.channel.close();
            this.channelShx.close();
        }
        catch (IOException e) {
            ret = new CloseException("SHPFile.close", (Throwable)e);
        }
        finally {
            try {
                this.fin.close();
                this.finShx.close();
            }
            catch (IOException e1) {
                ret = new CloseException("SHPFile.close", (Throwable)e1);
            }
        }
        if (ret != null) {
            throw ret;
        }
        this.bb = null;
        this.bbShx = null;
        this.fin = null;
        this.finShx = null;
        this.channel = null;
        this.channelShx = null;
        this.srsParameters = null;
    }

    @Override
    public boolean isOpen() {
        return this.fin != null;
    }

    @Override
    public synchronized void open() throws DataException {
        File prjFile;
        try {
            this.fin = new FileInputStream(this.params.getSHPFile());
        }
        catch (FileNotFoundException e) {
            throw new org.gvsig.fmap.dal.exception.FileNotFoundException(this.params.getSHPFileName());
        }
        this.channel = this.fin.getChannel();
        try {
            this.bb = new BigByteBuffer2(this.channel, FileChannel.MapMode.READ_ONLY);
        }
        catch (IOException e) {
            throw new ReadException(this.params.getSHPFileName(), (Throwable)e);
        }
        try {
            this.finShx = new FileInputStream(this.params.getSHXFile());
        }
        catch (FileNotFoundException e) {
            throw new org.gvsig.fmap.dal.exception.FileNotFoundException(this.params.getSHXFileName());
        }
        this.channelShx = this.finShx.getChannel();
        try {
            this.bbShx = new BigByteBuffer2(this.channelShx, FileChannel.MapMode.READ_ONLY);
        }
        catch (IOException e) {
            throw new ReadException(this.params.getSHXFileName(), (Throwable)e);
        }
        this.bbShx.order(ByteOrder.BIG_ENDIAN);
        ShapeFileHeader2 myHeader = new ShapeFileHeader2();
        this.bb.position(0L);
        myHeader.readHeader(this.bb);
        double[] min = new double[]{myHeader.myXmin, myHeader.myYmin};
        double[] max = new double[]{myHeader.myXmax, myHeader.myYmax};
        try {
            this.extent = this.gManager.createEnvelope(min[0], min[1], max[0], max[1], 0);
        }
        catch (CreateEnvelopeException e1) {
            logger.error("Error creating the envelope", (Throwable)e1);
        }
        this.type = myHeader.myShapeType;
        this.subType = this.getGeometrySubType();
        this.initSupportedGeometryTypes();
        double x = myHeader.myXmin;
        double y = myHeader.myYmin;
        double w = myHeader.myXmax - myHeader.myXmin;
        double h = myHeader.myYmax - myHeader.myYmin;
        if (w == 0.0) {
            x -= 0.1;
            w = 0.2;
        }
        if (h == 0.0) {
            y -= 0.1;
            h = 0.2;
        }
        if ((prjFile = SHP.getPrjFile(this.params.getSHPFile())).exists()) {
            BufferedReader input = null;
            try {
                input = new BufferedReader(new FileReader(prjFile));
            }
            catch (FileNotFoundException e) {
                throw new org.gvsig.fmap.dal.exception.FileNotFoundException(prjFile.getAbsolutePath());
            }
            try {
                this.srsParameters = input.readLine();
            }
            catch (IOException e) {
                throw new ReadException("SHPFile.open prj", (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.srsParameters = null;
    }

    @Override
    public Envelope getFullExtent() throws ReadException {
        return this.extent;
    }

    @Override
    public boolean isEditable() {
        return this.params.getDBFFile().canWrite() && this.params.getSHPFile().canWrite() && this.params.getSHXFile().canWrite();
    }

    @Override
    public int getGeometryType() throws ReadException {
        int auxType = 0;
        switch (this.type) {
            case 1: 
            case 11: {
                auxType |= 1;
                break;
            }
            case 3: 
            case 13: {
                auxType |= 8;
                break;
            }
            case 5: 
            case 15: {
                auxType |= 9;
                break;
            }
            case 8: 
            case 18: {
                auxType |= 7;
            }
        }
        return auxType;
    }

    @Override
    public int getGeometrySubType() throws ReadException {
        switch (this.type) {
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                return 0;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                return 1;
            }
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                return 2;
            }
        }
        return 4;
    }

    private Geometry getNullGeometry() throws CreateGeometryException {
        if (this.useNullGeometry) {
            return this.gtypeNull.create();
        }
        return null;
    }

    @Override
    public synchronized Geometry getGeometry(long position) throws ReadException, CreateGeometryException {
        this.bb.position(this.getPositionForRecord(position));
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int shapeType = this.bb.getInt();
        if (shapeType == 0) {
            return this.getNullGeometry();
        }
        if (shapeType != this.type) {
            return this.getNullGeometry();
        }
        switch (this.type) {
            case 1: 
            case 11: 
            case 21: {
                Point point = this.readPoint(this.bb);
                this.fillPoint(point);
                return point;
            }
            case 3: {
                Curve curve = (Curve)this.gtypeCurve2D.create();
                this.fillCurve(curve);
                if (curve.getNumVertices() == 0) {
                    return this.getNullGeometry();
                }
                return curve;
            }
            case 5: {
                Surface surface = (Surface)this.gtypeSurface2D.create();
                this.fillSurface(surface);
                if (surface.getNumVertices() == 0) {
                    return this.getNullGeometry();
                }
                return surface;
            }
            case 13: {
                Curve curve3D = (Curve)this.gManager.create(2, 1);
                this.fillCurve(curve3D);
                this.fillZ((OrientablePrimitive)curve3D);
                if (curve3D.getNumVertices() == 0) {
                    return this.getNullGeometry();
                }
                return curve3D;
            }
            case 15: {
                Surface surface3D = (Surface)this.gManager.create(3, 1);
                this.fillSurface(surface3D);
                this.fillZ((OrientablePrimitive)surface3D);
                if (surface3D.getNumVertices() == 0) {
                    return this.getNullGeometry();
                }
                return surface3D;
            }
            case 8: {
                Object p = null;
                this.bb.position(this.bb.position() + 32L);
                int numPoints = this.bb.getInt();
                Point[] points = new Point[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    points[i] = (Point)this.gManager.create(1, 0);
                    points[i].setX(this.bb.getDouble());
                    points[i].setY(this.bb.getDouble());
                }
                MultiPoint multipoint = (MultiPoint)this.gtypeMultiPoint2D.create();
                for (int k = 0; k < points.length; ++k) {
                    multipoint.addPoint(points[k]);
                }
                if (multipoint.getPrimitivesNumber() == 0) {
                    return this.getNullGeometry();
                }
                return multipoint;
            }
            case 18: {
                int i;
                this.bb.position(this.bb.position() + 32L);
                int numPoints = this.bb.getInt();
                double[] temX = new double[numPoints];
                double[] temY = new double[numPoints];
                double[] temZ = new double[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    temX[i] = this.bb.getDouble();
                    temY[i] = this.bb.getDouble();
                }
                for (i = 0; i < numPoints; ++i) {
                    temZ[i] = this.bb.getDouble();
                }
                MultiPoint multipoint3D = (MultiPoint)this.gManager.create(7, 1);
                for (int k = 0; k < temX.length; ++k) {
                    Point pointAux = (Point)this.gManager.create(1, 1);
                    pointAux.setX(temX[k]);
                    pointAux.setY(temY[k]);
                    pointAux.setCoordinateAt(2, temZ[k]);
                    multipoint3D.addPoint(pointAux);
                }
                if (multipoint3D.getPrimitivesNumber() == 0) {
                    return this.getNullGeometry();
                }
                return multipoint3D;
            }
        }
        return null;
    }

    private void fillPoint(Point point) throws ReadException {
        if (this.subType == 1) {
            point.setCoordinateAt(2, this.bb.getDouble());
        } else if (this.subType == 2) {
            point.setCoordinateAt(2, this.bb.getDouble());
        }
    }

    private void fillCurve(Curve curve) throws CreateGeometryException, ReadException {
        int i;
        Point p = null;
        this.bb.position(this.bb.position() + 32L);
        int numParts = this.bb.getInt();
        int numPoints = this.bb.getInt();
        int[] tempParts = new int[numParts];
        for (i = 0; i < numParts; ++i) {
            tempParts[i] = this.bb.getInt();
        }
        int j = 0;
        for (i = 0; i < numPoints; ++i) {
            p = this.readPoint(this.bb);
            if (i == tempParts[j]) {
                curve.addMoveToVertex(p);
                if (j >= numParts - 1) continue;
                ++j;
                continue;
            }
            curve.addVertex(p);
        }
    }

    private void fillSurface(Surface surface) throws CreateGeometryException, ReadException {
        int i;
        Point p = null;
        this.bb.position(this.bb.position() + 32L);
        int numParts = this.bb.getInt();
        int numPoints = this.bb.getInt();
        int[] tempParts = new int[numParts];
        for (i = 0; i < numParts; ++i) {
            tempParts[i] = this.bb.getInt();
        }
        int partIndex = 0;
        for (i = 0; i < numPoints; ++i) {
            p = this.readPoint(this.bb);
            if (i == tempParts[partIndex]) {
                surface.addMoveToVertex(p);
                if (partIndex >= numParts - 1) continue;
                ++partIndex;
                continue;
            }
            if (i == tempParts[partIndex] - 1 || i == numPoints - 1) {
                surface.closePrimitive();
                continue;
            }
            surface.addVertex(p);
        }
    }

    private void fillZ(OrientablePrimitive orientablePrimitive) throws CreateGeometryException, ReadException {
        double[] boxZ = new double[]{this.bb.getDouble(), this.bb.getDouble()};
        for (int i = 0; i < orientablePrimitive.getNumVertices(); ++i) {
            orientablePrimitive.setCoordinateAt(i, 2, this.bb.getDouble());
        }
    }

    private long getPositionForRecord(long numRec) {
        int posIndex = 100 + (int)numRec * 8;
        long pos = 8 + 2 * this.bbShx.getInt(posIndex);
        return pos;
    }

    private Point readPoint(BigByteBuffer2 in) throws CreateGeometryException, ReadException {
        in.order(ByteOrder.LITTLE_ENDIAN);
        return 0 == this.subType ? this.gtypePoint2D.createPoint(in.getDouble(), in.getDouble()) : this.gManager.createPoint(in.getDouble(), in.getDouble(), this.subType);
    }

    private Envelope readRectangle(BigByteBuffer2 in) throws CreateEnvelopeException {
        double y2;
        in.order(ByteOrder.LITTLE_ENDIAN);
        double x = in.getDouble();
        double y = in.getDouble();
        double x2 = in.getDouble();
        if (x2 - x == 0.0) {
            x2 += 0.2;
            x -= 0.1;
        }
        if ((y2 = in.getDouble()) - y == 0.0) {
            y2 += 0.2;
            y -= 0.1;
        }
        Envelope tempEnvelope = this.gManager.createEnvelope(x, y, x2, y2, 0);
        return tempEnvelope;
    }

    @Override
    public synchronized Envelope getBoundingBox(long featureIndex) throws ReadException, CreateEnvelopeException, CreateGeometryException {
        Point p = null;
        Envelope BoundingBox = null;
        try {
            this.bb.position(this.getPositionForRecord(featureIndex));
        }
        catch (Exception e) {
            throw new ReadException("getBondingBox (" + featureIndex + ")", (Throwable)e);
        }
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int tipoShape = this.bb.getInt();
        switch (tipoShape) {
            case 1: 
            case 11: {
                p = this.readPoint(this.bb);
                BoundingBox = this.gManager.createEnvelope(p.getX() - 0.1, p.getY() - 0.1, p.getX() + 0.2, p.getY() + 0.2, 0);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                BoundingBox = this.readRectangle(this.bb);
            }
        }
        return BoundingBox;
    }

    @Override
    public String getSRSParameters() {
        return this.srsParameters;
    }

    private void initSupportedGeometryTypes() throws ReadException {
        switch (this.getGeometryType()) {
            case 1: {
                this.supportedGeometryTypes = new int[]{1, 16};
                break;
            }
            case 7: {
                this.supportedGeometryTypes = new int[]{7, 16};
                break;
            }
            case 8: {
                this.supportedGeometryTypes = new int[]{2, 13, 12, 11, 3, 16, 8};
                break;
            }
            case 9: {
                this.supportedGeometryTypes = new int[]{13, 11, 3, 16, 9};
                break;
            }
            default: {
                this.supportedGeometryTypes = new int[0];
            }
        }
    }

    @Override
    public boolean canWriteGeometry(int gvSIGgeometryType) {
        for (int i = 0; i < this.supportedGeometryTypes.length; ++i) {
            if (gvSIGgeometryType != this.supportedGeometryTypes[i]) continue;
            return true;
        }
        return false;
    }
}

