/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.SHPMultiLine;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPPolygon
extends SHPMultiLine {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(SHPPolygon.class);

    public SHPPolygon() {
        this.m_type = 5;
    }

    public SHPPolygon(int type) {
        if (type == 5 || type == 25 || type != 15) {
            // empty if block
        }
        this.m_type = type;
    }

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Override
    public synchronized Geometry read(MappedByteBuffer buffer, int type) {
        double minX = buffer.getDouble();
        double minY = buffer.getDouble();
        double maxX = buffer.getDouble();
        double maxY = buffer.getDouble();
        Rectangle2D.Double rec = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - maxY);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        Point[] points = this.readPoints(buffer, numPoints);
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            Point[] pointsPart = new Point[length];
            for (int i = 0; i < length; ++i) {
                pointsPart[i] = points[offset++];
            }
        }
        try {
            return geomManager.createSurface(this.getGeneralPathX(points, partOffsets), 0);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating a surface", (Throwable)e);
            return null;
        }
    }

    private synchronized Point[] readPoints(MappedByteBuffer buffer, int numPoints) {
        Point[] points = new Point[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            try {
                points[t] = geomManager.createPoint(buffer.getDouble(), buffer.getDouble(), 0);
                continue;
            }
            catch (CreateGeometryException e) {
                logger.error("Error creating a point", (Throwable)e);
            }
        }
        return points;
    }

    @Override
    public synchronized void write(ByteBuffer buffer, Geometry geometry) {
        int t;
        Envelope env = geometry.getEnvelope();
        buffer.putDouble(env.getMinimum(0));
        buffer.putDouble(env.getMinimum(1));
        buffer.putDouble(env.getMaximum(0));
        buffer.putDouble(env.getMaximum(1));
        int nparts = this.parts.length;
        int npoints = this.points.length;
        buffer.putInt(nparts);
        buffer.putInt(npoints);
        for (t = 0; t < nparts; ++t) {
            buffer.putInt(this.parts[t]);
        }
        for (t = 0; t < this.points.length; ++t) {
            buffer.putDouble(this.points[t].getX());
            buffer.putDouble(this.points[t].getY());
        }
        if (this.m_type == 15) {
            double[] zExtreame = SHP.getZMinMax(this.zs);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t2 = 0; t2 < npoints; ++t2) {
                double z = this.zs[t2];
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.m_type == 25) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (int t3 = 0; t3 < npoints; ++t3) {
                buffer.putDouble(-1.0E41);
            }
        }
    }

    @Override
    public synchronized int getLength(Geometry fgeometry) {
        int length;
        int npoints = this.points.length;
        if (this.m_type == 15 || this.m_type == 25) {
            length = 44 + 4 * this.parts.length + 16 * npoints + 8 * npoints + 16;
        } else if (this.m_type == 5) {
            length = 44 + 4 * this.parts.length + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.m_type);
        }
        return length;
    }
}

