/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Objects;
import java.util.function.Function;
import javax.json.JsonObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisServerUtils.class);
    private static Writer consoleWriter = new NullWriter();
    private static JsonObject config = null;

    public static void setConsoleWriter(Writer console) {
        consoleWriter = console;
    }

    public static Writer getConsoleWriter() {
        return consoleWriter;
    }

    public static JsonObject getConfiguration() {
        return config;
    }

    public static void setConfiguration(JsonObject theConfig) {
        config = theConfig;
    }

    public static void setConfiguration(URL config_url) {
        InputStream config_is = null;
        try {
            config_is = config_url.openStream();
            JsonObject theConfig = Json.createObject((InputStream)config_is);
            VCSGisServerUtils.setConfiguration(theConfig);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't set configuration file (url=" + Objects.toString(config_url) + ").", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)config_is);
        }
    }

    public static void writeConfiguration(URL config_url) {
        if (config == null) {
            LOGGER.warn("Can't write configuration to null url.");
            return;
        }
        FileOutputStream os = null;
        try {
            File f = URLUtils.toFile((URL)config_url);
            os = new FileOutputStream(f);
            IOUtils.write((String)config.toString(), (OutputStream)os);
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't write configuration to " + Objects.toString(config_url) + " url.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static void setConnectionParameters(JDBCServerExplorerParameters connectionParameters) {
        JsonObjectBuilder config_builder = Json.createObjectBuilder((JsonObject)config);
        config_builder.add("ConnectionParameters", (SupportToJson)connectionParameters);
        config = config_builder.build();
    }

    public static JDBCServerExplorerParameters getConnectionParameters(JsonObject config) {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JsonObject connectionParameters_json = config.getJsonObject("ConnectionParameters");
            JDBCServerExplorerParameters connectionParameters = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters(connectionParameters_json.getString("ProviderName"));
            connectionParameters.fromJson(connectionParameters_json);
            return connectionParameters;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create connection parameters.", (Throwable)ex);
            return null;
        }
    }

    public static void console_writeln(String s) {
        try {
            consoleWriter.write(s);
            consoleWriter.write("\n");
        }
        catch (Exception ex) {
            LOGGER.info(s);
        }
    }

    public static URL getConfigurationURL(String contextID, String contextRootRealPath, Function<String, URL> getResouce) {
        try {
            URL config_url;
            String configFileName;
            String defaultConfigFileName;
            block30: {
                defaultConfigFileName = "vcsgisserver.config";
                configFileName = contextID + ".config";
                config_url = null;
                String custom_config_file = System.getenv().get("VCSGIS_SERVER_CONFIG");
                if (StringUtils.isNotBlank((CharSequence)custom_config_file)) {
                    try {
                        File f = new File(custom_config_file);
                        if (f.exists()) {
                            config_url = URLUtils.toURL((File)f);
                            break block30;
                        }
                        LOGGER.info("VCSGIS_SERVER_CONFIG (" + f.toString() + ") not exists");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't open custom config file (" + custom_config_file + ")", (Throwable)ex);
                    }
                } else {
                    LOGGER.info("VCSGIS_SERVER_CONFIG is blank");
                }
            }
            if (config_url == null) {
                String catalina_base = System.getenv().get("CATALINA_BASE");
                if (StringUtils.isNotBlank((CharSequence)catalina_base)) {
                    try {
                        File f = FileUtils.getFile((String[])new String[]{catalina_base, "conf", configFileName});
                        if (!f.exists()) {
                            LOGGER.info("CATALINA_BASE/conf/" + configFileName + " (" + f.toString() + ") not exists");
                            f = FileUtils.getFile((String[])new String[]{catalina_base, "conf", defaultConfigFileName});
                            if (!f.exists()) {
                                LOGGER.info("CATALINA_BASE/conf/" + defaultConfigFileName + " (" + f.toString() + ") not exists");
                                f = null;
                            }
                        }
                        if (f != null) {
                            config_url = URLUtils.toURL((File)f);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't get config file from 'CATALINE_BASE/conf/" + configFileName + "'.", (Throwable)ex);
                    }
                } else {
                    LOGGER.info("CATALINA_BASE is blank");
                }
            }
            if (config_url == null) {
                File webapps_folder = null;
                File conf_folder = null;
                try {
                    webapps_folder = new File(contextRootRealPath);
                }
                catch (Exception ex) {
                    LOGGER.debug("", (Throwable)ex);
                }
                if (webapps_folder != null) {
                    try {
                        conf_folder = new File(webapps_folder, "../../conf").getCanonicalFile();
                        if (!conf_folder.exists()) {
                            LOGGER.info("CanonicalFile /../../conf is null");
                            conf_folder = null;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.debug("", (Throwable)ex);
                    }
                    if (conf_folder != null) {
                        try {
                            File f = FileUtils.getFile((File)conf_folder, (String[])new String[]{configFileName});
                            if (!f.exists()) {
                                LOGGER.info("conf/" + configFileName + " (" + f.toString() + ") not exists");
                                f = FileUtils.getFile((File)conf_folder, (String[])new String[]{defaultConfigFileName});
                                if (!f.exists()) {
                                    LOGGER.info("conf/" + defaultConfigFileName + " (" + f.toString() + ") not exists");
                                    f = null;
                                }
                            }
                            if (f != null) {
                                config_url = URLUtils.toURL((File)f);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't get config file from '" + conf_folder.getAbsolutePath() + "/" + configFileName + "'.", (Throwable)ex);
                        }
                    }
                } else {
                    LOGGER.info("RealPath / is null");
                }
            }
            if (config_url == null) {
                config_url = getResouce.apply("/WEB-INF/" + defaultConfigFileName);
            }
            return config_url;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

