/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.SODS.spreadsheet;

import com.github.miachm.SODS.io.OdsReader;
import com.github.miachm.SODS.io.OdsWritter;
import com.github.miachm.SODS.spreadsheet.Sheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class SpreadSheet
implements Cloneable {
    private List<Sheet> sheets = new ArrayList<Sheet>();
    private Locale locale;

    public SpreadSheet() {
    }

    public SpreadSheet(File file) throws IOException {
        this(new FileInputStream(file), null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadSheet that = (SpreadSheet)o;
        return this.sheets.equals(that.sheets);
    }

    public int hashCode() {
        return this.sheets.hashCode();
    }

    public SpreadSheet(InputStream in) throws IOException {
        this(in, null);
    }

    public SpreadSheet(InputStream in, Locale locale) throws IOException {
        this.locale = locale == null ? Locale.getDefault() : locale;
        OdsReader.load(in, this);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object clone() throws CloneNotSupportedException {
        SpreadSheet spread = new SpreadSheet();
        for (Sheet sheet : this.sheets) {
            spread.appendSheet((Sheet)sheet.clone());
        }
        return spread;
    }

    public void appendSheet(Sheet sheet) {
        this.addSheet(sheet, this.sheets.size());
    }

    public void addSheet(Sheet sheet, int pos) {
        this.sheets.add(pos, sheet);
    }

    public void clear() {
        this.sheets.clear();
    }

    public void deleteSheet(int pos) {
        this.sheets.remove(pos);
    }

    public boolean deleteSheet(String name) {
        return this.sheets.removeIf(sheet -> sheet.getName().equals(name));
    }

    public boolean deleteSheet(Sheet sheet) {
        return this.deleteSheet(sheet.getName());
    }

    public List<Sheet> getSheets() {
        return Collections.unmodifiableList(this.sheets);
    }

    public int getNumSheets() {
        return this.sheets.size();
    }

    public Sheet getSheet(String name) {
        for (Sheet sheet : this.sheets) {
            if (!sheet.getName().equals(name)) continue;
            return sheet;
        }
        return null;
    }

    public Sheet getSheet(int index) {
        return this.sheets.get(index);
    }

    public void setSheet(Sheet sheet, int pos) {
        this.sheets.set(pos, sheet);
    }

    public void save(File out) throws IOException {
        this.save(new FileOutputStream(out));
    }

    public void save(OutputStream out) throws IOException {
        OdsWritter.save(out, this);
    }

    public void sortSheets() {
        Collections.sort(this.sheets);
    }

    public void sortSheets(Comparator<Sheet> comparator) {
        this.sheets.sort(comparator);
    }

    public String toString() {
        return "SpreadSheet{sheets=" + this.sheets + '}';
    }
}

