/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.newlayer.NewLayerException;
import org.gvsig.newlayer.NewLayerManager;
import org.gvsig.newlayer.NewLayerProvider;
import org.gvsig.newlayer.NewLayerProviderFactory;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerServiceException;
import org.gvsig.tools.service.ServiceException;

public class DefaultNewLayerService
implements NewLayerService {
    private final NewLayerManager newLayerManager;
    private NewLayerProviderFactory type;
    private NewLayerProvider provider;
    private boolean addTableToProject = true;
    private IProjection defaultProjection;
    private Set<NewLayerService.NewLayerServiceListener> listeners = null;

    public DefaultNewLayerService(NewLayerManager manager) {
        this.newLayerManager = manager;
    }

    public NewLayerProvider getProvider() {
        return this.provider;
    }

    public void createTable() throws NewLayerServiceException {
        try {
            this.getExplorer().add(this.getStoreProviderName(), (NewDataStoreParameters)this.getNewStoreParameters(), true);
            this.firePostCreateTable();
        }
        catch (Exception e) {
            throw new CantCreateNewLayerException(e);
        }
    }

    public void setType(String type) {
        try {
            this.setProviderFactory(this.newLayerManager.getNewLayerProviderFactory(type));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public DataServerExplorer getExplorer() throws NewLayerException {
        return this.getProvider().getExplorer();
    }

    public String getStoreProviderName() {
        return this.getProvider().getStoreName();
    }

    public EditableFeatureType getFeatureType() {
        return this.getProvider().getFeatureType();
    }

    public NewFeatureStoreParameters getNewStoreParameters() throws NewLayerException {
        return this.getProvider().getNewStoreParameters();
    }

    public DataStoreParameters getOpenStoreParameters() throws NewLayerException {
        return this.getProvider().getOpenStoreParameters();
    }

    public NewFeatureStoreParameters getNewStoreParametersQuietly() {
        try {
            return this.getProvider().getNewStoreParameters();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public DataStoreParameters getOpenStoreParametersQuietly() {
        try {
            return this.getProvider().getOpenStoreParameters();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        List<NewLayerProviderFactory> providers = this.getProviderFactories();
        for (NewLayerProviderFactory newLayerProviderFactory : providers) {
            types.add(newLayerProviderFactory.getName());
        }
        return types;
    }

    public String getType() {
        return this.type.getName();
    }

    public void setAddTableToProject(boolean b) {
        this.addTableToProject = b;
    }

    public boolean isAddTableToProject() {
        return this.addTableToProject;
    }

    public void setProviderFactory(NewLayerProviderFactory type) {
        this.type = type;
        this.provider = type.create((NewLayerService)this);
    }

    public NewLayerProviderFactory getProviderFactory() {
        return this.type;
    }

    public List<NewLayerProviderFactory> getProviderFactories() {
        ArrayList<NewLayerProviderFactory> providers = new ArrayList<NewLayerProviderFactory>(this.newLayerManager.getProviders(NewLayerManager.STORETYPE.ANY));
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            NewLayerProviderFactory newLayerProviderFactory = (NewLayerProviderFactory)iterator.next();
            if (newLayerProviderFactory.isEnabled()) continue;
            iterator.remove();
        }
        return providers;
    }

    public void addNewLayerServiceListener(NewLayerService.NewLayerServiceListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<NewLayerService.NewLayerServiceListener>();
        }
        this.listeners.add(listener);
    }

    protected void firePostCreateTable() {
        if (this.listeners == null) {
            return;
        }
        for (NewLayerService.NewLayerServiceListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                listener.postCreateTable((NewLayerService)this);
            }
            catch (Throwable throwable) {}
        }
    }

    public void setDefaultProjection(IProjection projection) {
        this.defaultProjection = projection;
    }

    public IProjection getDefaultProjection() {
        return this.defaultProjection;
    }

    public class CantLoadNewLayerException
    extends NewLayerServiceException {
        private static final long serialVersionUID = -1711950651766745963L;

        public CantLoadNewLayerException(Throwable cause) {
            super("Can't load the new layer", cause, "_cant_load_the_new_layer", -1711950651766745963L);
        }
    }

    public class CantOpenStoreException
    extends NewLayerServiceException {
        private static final long serialVersionUID = -2245228621032918630L;

        public CantOpenStoreException(Throwable cause) {
            super("Can't open store", cause, "_cant_open_store", -2245228621032918630L);
        }
    }

    public class CantCreateNewLayerException
    extends NewLayerServiceException {
        private static final long serialVersionUID = 4208215791054246118L;

        public CantCreateNewLayerException(Throwable cause) {
            super("Can't create the layer", cause, "_cant_create_the_layer", 4208215791054246118L);
        }
    }
}

