/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerChangeSupport {
    private static final Logger logger = LoggerFactory.getLogger(LayerChangeSupport.class);
    private final Set<LegendListener> listeners = new HashSet<LegendListener>();

    public void addLayerListener(LegendListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeLayerListener(LegendListener listener) {
        this.listeners.remove(listener);
    }

    public void callLegendChanged(LegendChangedEvent e) {
        for (int i = 0; i < 10; ++i) {
            try {
                Iterator<LegendListener> iterator = this.listeners.iterator();
                if (!iterator.hasNext()) continue;
                LegendListener listener = iterator.next();
                try {
                    listener.legendChanged(e);
                }
                catch (Exception ex) {
                    logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
                }
                continue;
            }
            catch (ConcurrentModificationException ex) {
                // empty catch block
            }
        }
    }
}

