/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractCartographicSupport;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSymbol
extends AbstractCartographicSupport
implements ISymbol_v2,
CartographicSupport {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSymbol.class);
    public static final String SYMBOL_PERSISTENCE_DEFINITION_NAME = "Symbol";
    private static final String FIELD_UNIT = "unit";
    private static final String FIELD_REFERENCE_SYSTEM = "referenceSystem";
    private static final String FIELD_IS_SHAPE_VISIBLE = "isShapeVisible";
    private static final String FIELD_DESCRIPTION = "description";
    private String desc;
    private String id;
    private boolean isShapeVisible = true;
    private transient Feature feature;

    @Override
    public Feature getFeature() {
        return this.feature;
    }

    @Override
    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    @Override
    public final void setDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public final String getDescription() {
        return this.desc;
    }

    @Override
    public final void setID(String id) {
        this.id = id;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public boolean isShapeVisible() {
        return this.isShapeVisible;
    }

    public final void setIsShapeVisible(boolean isShapeVisible) {
        this.isShapeVisible = isShapeVisible;
    }

    private boolean areEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object obj) {
        ISymbol other = null;
        if (!(obj instanceof ISymbol)) {
            return false;
        }
        other = (ISymbol)obj;
        if (!this.areEquals(other.getClass(), this.getClass())) {
            return false;
        }
        if (!this.areEquals(other.getColor(), this.getColor())) {
            return false;
        }
        return this.areEquals(other.getDescription(), this.getDescription());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected ISymbol cloneForSelection() {
        return this.cloneForSelection(MapContext.DEFAULT_SELECTION_COLOR);
    }

    protected ISymbol cloneForSelection(Color selectionColor) {
        try {
            ISymbol selectionSymbol = (ISymbol)this.clone();
            selectionSymbol.setColor(selectionColor);
            if (this.getDescription() != null) {
                selectionSymbol.setDescription(this.getDescription().concat(" version for selection"));
            } else {
                selectionSymbol.setDescription("version for selection");
            }
            return selectionSymbol;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Error creating the selection symbol for the symbol " + this, (Throwable)e);
            return null;
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setDescription(state.getString(FIELD_DESCRIPTION));
        this.setIsShapeVisible(state.getBoolean(FIELD_IS_SHAPE_VISIBLE));
        this.setReferenceSystem(state.getInt(FIELD_REFERENCE_SYSTEM));
        this.setUnit(state.getInt(FIELD_UNIT));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_DESCRIPTION, this.getDescription());
        state.set(FIELD_IS_SHAPE_VISIBLE, this.isShapeVisible());
        state.set(FIELD_REFERENCE_SYSTEM, this.getReferenceSystem());
        state.set(FIELD_UNIT, this.getUnit());
    }

    public String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        return new String[]{featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName()};
    }

    @Override
    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel) {
        this.draw(g, affineTransform, geom, f, cancel, null);
    }

    @Override
    public void drawInsideRectangle(Graphics2D g, AffineTransform affineTransform, Rectangle r) throws SymbolDrawingException {
        this.draw(g, affineTransform, null, null, null, r);
    }

    @Override
    public void print(Graphics2D g, AffineTransform affineTransform, Geometry geom, PrintAttributes properties) {
        this.draw(g, affineTransform, geom, null, null, null);
    }

    @Override
    public ISymbol getSymbolForSelection() {
        return this.getSymbolForSelection(MapContext.DEFAULT_SELECTION_COLOR);
    }

    @Override
    public ISymbol getSymbolForSelection(Color selectionColor) {
        return this.getSymbolForSelection();
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractSymbol.SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractSymbol.class, AbstractSymbol.SYMBOL_PERSISTENCE_DEFINITION_NAME, "Symbol persistence definition", null, null);
                definition.addDynFieldString(AbstractSymbol.FIELD_DESCRIPTION);
                definition.addDynFieldBoolean(AbstractSymbol.FIELD_IS_SHAPE_VISIBLE).setMandatory(true);
                definition.addDynFieldInt(AbstractSymbol.FIELD_REFERENCE_SYSTEM).setMandatory(true);
                definition.addDynFieldInt(AbstractSymbol.FIELD_UNIT).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

