/*
 * Decompiled with CFR 0.152.
 */
package com.k_int.codec.runtime;

import com.k_int.codec.runtime.AsnBitString;
import com.k_int.codec.runtime.AsnNull;
import com.k_int.codec.runtime.ChoiceType;
import com.k_int.codec.runtime.CodecStackInfo;
import com.k_int.codec.runtime.SerializationManager;
import com.k_int.codec.runtime.base_codec;
import com.k_int.util.LoggingFacade.LogContextFactory;
import com.k_int.util.LoggingFacade.LoggingContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class BEROutputStream
extends ByteArrayOutputStream
implements SerializationManager {
    Stack encoding_info = new Stack();
    public int tag_class = -1;
    public int tag_value = -1;
    public boolean is_constructed = false;
    public String encoding = "US-ASCII";
    private base_codec codec_hint = null;
    private static LoggingContext cat = LogContextFactory.getContext((String)"A2JRuntime");

    public BEROutputStream() {
    }

    public BEROutputStream(String string) {
        this.encoding = string;
    }

    public BEROutputStream(int n) {
        super(n);
    }

    public BEROutputStream(int n, String string) {
        super(n);
        this.encoding = string;
    }

    public int getDirection() {
        return 0;
    }

    public int tag_codec(boolean bl) throws IOException {
        if (this.tag_class == -1) {
            throw new IOException("Trying to write an un-initialized tag");
        }
        int n = this.tag_class;
        if (bl) {
            n |= 0x20;
        }
        if (this.tag_value < 31) {
            this.write(n | this.tag_value);
        } else {
            this.write(n | 0x1F);
            this.encodeBase128Int(this.tag_value);
        }
        this.tag_class = -1;
        this.tag_value = -1;
        return 1;
    }

    public byte[] octetstring_codec(Object object, boolean bl) throws IOException {
        byte[] byArray = (byte[])object;
        this.encodeLength(byArray.length);
        this.write(byArray);
        return byArray;
    }

    public Boolean boolean_codec(Object object, boolean bl) throws IOException {
        Boolean bl2 = (Boolean)object;
        this.encodeLength(1);
        this.write(bl2 != false ? 1 : 0);
        return bl2;
    }

    public BigInteger integer_codec(Object object, boolean bl) throws IOException {
        BigInteger bigInteger = (BigInteger)object;
        if (bigInteger != null) {
            boolean bl2 = false;
            byte[] byArray = bigInteger.toByteArray();
            if ((byArray[0] & 0x80) != 0) {
                throw new IllegalArgumentException("Illegal internal encoding");
            }
            this.encodeLength(byArray.length);
            this.write(byArray);
            this.flush();
        }
        return bigInteger;
    }

    public int[] oid_codec(Object object, boolean bl) throws IOException {
        int[] nArray = (int[])object;
        int n = nArray.length;
        int n2 = this.count;
        this.write(0);
        if (n > 1) {
            byte by = (byte)(nArray[0] * 40 + nArray[1]);
            this.write(by);
            int n3 = 2;
            while (n3 < n) {
                this.encodeBase128Int(nArray[n3]);
                ++n3;
            }
            this.rewriteLength(n2, this.count - (n2 + 1), 1);
        }
        return nArray;
    }

    public byte[] any_codec(Object object, boolean bl) throws IOException {
        byte[] byArray = (byte[])object;
        this.encodeLength(byArray.length);
        this.write(byArray);
        return byArray;
    }

    public AsnBitString bitstring_codec(Object object, boolean bl) throws IOException {
        AsnBitString asnBitString = (AsnBitString)object;
        int n = asnBitString.getValue().length + 1;
        this.encodeLength(n);
        this.write(0);
        this.write(asnBitString.getValue());
        return asnBitString;
    }

    public AsnNull null_codec(Object object, boolean bl) throws IOException {
        AsnNull asnNull = (AsnNull)object;
        this.encodeLength(0);
        return asnNull;
    }

    public Object choice(Object object, Object[][] objectArray, String string) throws IOException {
        ChoiceType choiceType = (ChoiceType)object;
        Integer n = (Integer)objectArray[choiceType.which][0];
        Integer n2 = (Integer)objectArray[choiceType.which][1];
        Integer n3 = (Integer)objectArray[choiceType.which][2];
        base_codec base_codec2 = (base_codec)objectArray[choiceType.which][3];
        if (n.equals(SerializationManager.TAGMODE_NONE)) {
            base_codec2.serialize(this, choiceType.o, false, (String)objectArray[choiceType.which][4]);
        } else if (n.equals(SerializationManager.IMPLICIT)) {
            this.implicit_settag(n2, n3);
            base_codec2.serialize(this, choiceType.o, false, (String)objectArray[choiceType.which][4]);
        } else {
            this.constructedBegin(n2, n3);
            base_codec2.serialize(this, choiceType.o, false, (String)objectArray[choiceType.which][4]);
            this.constructedEnd();
        }
        return object;
    }

    public boolean sequenceBegin() throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = 0;
            this.tag_value = 16;
        }
        return this.constructedBegin(this.tag_class, this.tag_value);
    }

    public boolean sequenceEnd() {
        return this.constructedEnd();
    }

    public boolean constructedBegin(int n, int n2) throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = n;
            this.tag_value = n2;
        }
        this.tag_codec(true);
        CodecStackInfo codecStackInfo = new CodecStackInfo();
        codecStackInfo.len_offset = this.count;
        codecStackInfo.lenlen = 4;
        this.write(0);
        this.write(0);
        this.write(0);
        this.write(0);
        codecStackInfo.contents_offset = this.count;
        this.encoding_info.push(codecStackInfo);
        return true;
    }

    public boolean constructedEnd() {
        CodecStackInfo codecStackInfo = (CodecStackInfo)this.encoding_info.pop();
        int n = this.count - codecStackInfo.contents_offset;
        this.rewriteLength(codecStackInfo.len_offset, n, codecStackInfo.lenlen);
        return true;
    }

    public Object implicit_tag(base_codec base_codec2, Object object, int n, int n2, boolean bl, String string) throws IOException {
        if (null != object) {
            this.implicit_settag(n, n2);
            base_codec2.serialize(this, object, bl, string);
        } else if (!bl) {
            throw new IOException("Missing mandatory member: " + string);
        }
        return object;
    }

    public Object explicit_tag(base_codec base_codec2, Object object, int n, int n2, boolean bl, String string) throws IOException {
        if (null != object) {
            this.constructedBegin(n, n2);
            base_codec2.serialize(this, object, bl, string);
            this.constructedEnd();
        } else if (!bl) {
            throw new IOException("Missing mandatory member: " + string);
        }
        return object;
    }

    public Vector sequenceOf(Vector vector, base_codec base_codec2) throws IOException {
        if (null != vector && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                base_codec2.serialize(this, e, true, "SequenceOfElement");
            }
        }
        return vector;
    }

    public void implicit_settag(int n, int n2) {
        if (this.tag_class < 0) {
            this.tag_class = n;
            this.tag_value = n2;
        }
    }

    private boolean tag() {
        return true;
    }

    private int encodeLength(int n) {
        if (n >= 128) {
            int n2 = n >= 0x1000000 ? 4 : (n >= 65536 ? 3 : (n >= 256 ? 2 : 1));
            this.write(0x80 | n2);
            int n3 = (n2 - 1) * 8;
            while (n3 >= 0) {
                this.write(n >> n3);
                n3 -= 8;
            }
            return n2;
        }
        this.write(n);
        return 1;
    }

    private boolean rewriteLength(int n, int n2, int n3) {
        int n4 = n;
        if (n3 > 1) {
            byte by = (byte)(n3 - 1);
            this.buf[n4++] = (byte)(0x80 | by);
            int n5 = (by - 1) * 8;
            while (n5 >= 0) {
                this.buf[n4++] = (byte)(n2 >> n5);
                n5 -= 8;
            }
        } else if (n2 > 127) {
            System.err.println("Asked to encode a value > 127 in only one length octet");
            System.exit(1);
        } else {
            this.buf[n4] = (byte)n2;
        }
        return true;
    }

    private int encodeTag() {
        return 1;
    }

    private void encodeBase128Int(int n) throws IOException {
        byte[] byArray = new byte[10];
        int n2 = 0;
        while (n > 127 && n2 < 9) {
            byArray[n2++] = (byte)(n & 0x7F);
            n >>= 7;
        }
        byArray[n2] = (byte)n;
        while (n2 >= 0) {
            this.write(byArray[n2] | (n2 == 0 ? 0 : 128));
            --n2;
        }
    }

    public base_codec getHintCodec() {
        return this.codec_hint;
    }

    public void setHintCodec(base_codec base_codec2) {
        this.codec_hint = base_codec2;
    }

    public String getCharsetEncoding() {
        return this.encoding;
    }
}

