/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.prov.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.newlayer.NewLayerException;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.prov.jdbc.NewLayerJDBCProviderParameters;
import org.gvsig.newlayer.prov.jdbc.panels.GeometryIndexPanel;
import org.gvsig.newlayer.prov.jdbc.panels.IdentifiersOptionsPanel;
import org.gvsig.newlayer.prov.jdbc.panels.JDBCConnectionPanel;
import org.gvsig.newlayer.prov.jdbc.panels.PermissionsPanel;
import org.gvsig.newlayer.prov.jdbc.panels.PostCreatingStatementPanel;
import org.gvsig.newlayer.prov.jdbc.panels.SelectTableNamePanel;
import org.gvsig.newlayer.spi.AbstractNewLayerProvider;

public class NewLayerJDBCProvider
extends AbstractNewLayerProvider {
    private final NewLayerJDBCProviderParameters parameters = new NewLayerJDBCProviderParameters();

    protected NewLayerJDBCProvider(NewLayerService service) {
        super(service);
    }

    public List<NewLayerProviderPanel> createPanels(NewLayerWizard wizard) {
        ArrayList<NewLayerProviderPanel> panels = new ArrayList<NewLayerProviderPanel>();
        panels.add(new IdentifiersOptionsPanel(wizard, this.parameters));
        panels.add(new JDBCConnectionPanel(wizard, this.parameters));
        panels.add(new SelectTableNamePanel(wizard, this.parameters));
        panels.add(wizard.createFeatureTypePanel());
        panels.add(new GeometryIndexPanel(wizard, this.parameters));
        panels.add(new PermissionsPanel(wizard, this.parameters));
        panels.add(new PostCreatingStatementPanel(wizard, this.parameters));
        return panels;
    }

    public EditableFeatureType getFeatureType() {
        return this.parameters.getFeatureType();
    }

    public NewLayerJDBCProviderParameters getParameters() {
        return this.parameters;
    }

    private JDBCServerExplorer createServerExplorer() throws NewLayerException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(this.getParameters().getExplorerParameters().getExplorerName(), (DataServerExplorerParameters)this.getParameters().getExplorerParameters());
            return explorer;
        }
        catch (Exception e) {
            throw new NewLayerException(e);
        }
    }

    public NewFeatureStoreParameters getNewStoreParameters() throws NewLayerException {
        try {
            EditableFeatureAttributeDescriptor attrdescriptor;
            EditableFeatureType featureType = this.parameters.getFeatureType();
            JDBCServerExplorer explorer = this.createServerExplorer();
            String pkname = this.getParameters().getPrimaryKey();
            if (pkname != null) {
                EditableFeatureAttributeDescriptor pk = (EditableFeatureAttributeDescriptor)featureType.get(pkname);
                if (pk == null) {
                    pk = featureType.add(pkname, 5);
                    pk.setIsPrimaryKey(true);
                    pk.setIsAutomatic(true);
                } else {
                    pk.setIsPrimaryKey(true);
                }
            }
            if ((attrdescriptor = (EditableFeatureAttributeDescriptor)featureType.getDefaultGeometryAttribute()) != null && this.getParameters().getCreateIndexInGeometryRow()) {
                attrdescriptor.setIsIndexed(true);
            }
            if (attrdescriptor != null) {
                attrdescriptor.setSRS(this.getParameters().getProjection());
            }
            JDBCNewStoreParameters createTableParams = explorer.getAddParameters();
            createTableParams.setSelectRole(this.getParameters().getSelectRole());
            createTableParams.setInsertRole(this.getParameters().getInsertRole());
            createTableParams.setUpdateRole(this.getParameters().getUpdateRole());
            createTableParams.setDeleteRole(this.getParameters().getDeleteRole());
            createTableParams.setTruncateRole(this.getParameters().getTruncateRole());
            createTableParams.setReferenceRole(this.getParameters().getReferenceRole());
            createTableParams.setTriggerRole(this.getParameters().getTriggerRole());
            createTableParams.setAllRole(this.getParameters().getAllRole());
            createTableParams.setSchema(this.getParameters().getSchema());
            createTableParams.setPostCreatingStatement(this.getParameters().getPostCreatingStatement());
            createTableParams.setDefaultFeatureType((FeatureType)featureType);
            createTableParams.setTable(this.getParameters().getTableName());
            return createTableParams;
        }
        catch (Exception ex) {
            throw new NewLayerException(ex);
        }
    }

    public DataStoreParameters getOpenStoreParameters() throws NewLayerException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = this.createServerExplorer();
            JDBCStoreParameters openStoreParameters = (JDBCStoreParameters)explorer.getOpenParameters();
            openStoreParameters.setSchema(this.getParameters().getSchema());
            openStoreParameters.setTable(this.getParameters().getTableName());
            openStoreParameters.setCRS(this.getParameters().getProjection());
            openStoreParameters.setDefaultGeometryField(this.getParameters().getFeatureType().getDefaultGeometryAttributeName());
            return openStoreParameters;
        }
        catch (DataException ex) {
            throw new NewLayerException((Exception)((Object)ex));
        }
    }

    public DataServerExplorer getExplorer() throws NewLayerException {
        return this.createServerExplorer();
    }

    public String getStoreName() {
        return this.parameters.getExplorerParameters().getProviderName();
    }
}

