/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.lib.impl.regionalpha;

import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roimask.lib.impl.regionalpha.RegionAlphaUI;

public class RegionAlphaFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"regionalpha"};
    private RegionAlphaUI regionAlphaUI = null;
    private List<ROI> roiList = null;
    protected boolean[] selectedROI = null;
    protected int alpha = 255;
    protected boolean inverse = false;
    protected double cellsize = 0.0;
    protected Extent bufferExtent = null;

    public RegionAlphaFilter() {
        this.setName(names[0]);
    }

    public String getGroup() {
        return "mascaras";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        Params params = RasterLocator.getManager().createParams("Panel", (Object)this.getRegionAlphaUI(), -1, null);
        params.setParam("FilterName", (Object)nameFilter, -1, null);
        params.setParam("Alpha", (Object)new Integer(this.alpha), 3, new String[]{"0", "255", "0", "1", "25"});
        return params;
    }

    private RegionAlphaUI getRegionAlphaUI() {
        if (this.regionAlphaUI == null) {
            this.regionAlphaUI = new RegionAlphaUI();
            this.regionAlphaUI.setROIList(this.getROIList());
        }
        return this.regionAlphaUI;
    }

    protected List<ROI> getROIList() {
        if (this.roiList == null) {
            this.roiList = (List)this.getEnv().get("SrcROI");
        }
        return this.roiList;
    }

    public void pre() throws FilterAddException {
        super.pre();
        Boolean inverseBoolean = (Boolean)this.params.get("inverse");
        if (inverseBoolean != null) {
            this.inverse = inverseBoolean;
        }
        this.alpha = (Integer)this.params.get("alpha");
        this.selectedROI = (boolean[])this.params.get("selected_roi");
        if (this.raster.getDataExtent() == null) {
            throw new FilterAddException("Buffer extension cannot be null");
        }
        this.bufferExtent = RasterLocator.getManager().getDataStructFactory().createExtent(this.raster.getDataExtent());
        this.cellsize = this.raster.getDataExtent().getWidth() / (double)this.raster.getWidth();
        if (this.hasInputTransparency()) {
            this.createBufferResult(this.raster.getDataType(), this.raster.getBandCount());
        } else {
            this.createBufferResult(this.raster.getDataType(), this.raster.getBandCount() + 1);
        }
    }

    public Object getResult(String name) {
        if (name.equals("transparency")) {
            String[] values = new String[this.rasterResult.getBandCount()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = "Undefined";
            }
            ColorInterpretation ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(values);
            ci.setColorInterpValue(this.rasterResult.getBandCount() - 1, "Alpha");
            this.transparency.setColorInterpretation(ci);
            this.transparency.activeTransparency();
            return this.transparency;
        }
        return super.getResult(name);
    }

    public void post() {
    }

    public void process(int x, int y) {
    }

    public int getInRasterDataType() {
        return 0;
    }

    public int getOutRasterDataType() {
        return 0;
    }
}

