/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.distributionanalysis.EUCTWDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.EUCTWSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class EUCTWProber
extends CharsetProber {
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private CharsetProber.ProbingState state;
    private EUCTWDistributionAnalysis distributionAnalyzer = new EUCTWDistributionAnalysis();
    private byte[] lastChar = new byte[2];
    private static final SMModel smModel = new EUCTWSMModel();

    public EUCTWProber() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_EUC_TW;
    }

    @Override
    public float getConfidence() {
        float f = this.distributionAnalyzer.getConfidence();
        return f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = this.codingSM.nextState(byArray[i]);
            if (n4 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n4 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n4 != 0) continue;
            int n5 = this.codingSM.getCurrentCharLen();
            if (i == n) {
                this.lastChar[1] = byArray[n];
                this.distributionAnalyzer.handleOneChar(this.lastChar, 0, n5);
                continue;
            }
            this.distributionAnalyzer.handleOneChar(byArray, i - 1, n5);
        }
        this.lastChar[0] = byArray[n3 - 1];
        if (this.state == CharsetProber.ProbingState.DETECTING && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.codingSM.reset();
        this.state = CharsetProber.ProbingState.DETECTING;
        this.distributionAnalyzer.reset();
        Arrays.fill(this.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

