/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.NullCompletor;
import jline.Terminal;
import workbench.console.ClipCompletor;
import workbench.console.WbConsole;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;

public class JLineWrapper
implements WbConsole {
    private ConsoleReader reader = new ConsoleReader();

    public JLineWrapper() throws IOException {
        this.reader.setUseHistory(true);
        this.reader.setUsePagination(false);
        this.reader.setBellEnabled(false);
        ArrayList<Completor> arrayList = new ArrayList<Completor>(2);
        arrayList.add(new ClipCompletor());
        arrayList.add(new NullCompletor());
        this.reader.addCompletor(new ArgumentCompletor(arrayList));
    }

    @Override
    public void clearScreen() {
        try {
            this.reader.clearScreen();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        try {
            this.reader.printString("\u001b[2K");
            this.reader.killLine();
            this.reader.printNewline();
            this.reader.getInput().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public char readCharacter() {
        try {
            return (char)this.reader.readVirtualKey();
        }
        catch (IOException iOException) {
            return '\u0000';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLineWithoutHistory(String string) {
        boolean bl = this.reader.getUseHistory();
        try {
            this.reader.setUseHistory(false);
            String string2 = this.readLine(string);
            return string2;
        }
        finally {
            this.reader.setUseHistory(bl);
        }
    }

    @Override
    public int getColumns() {
        Terminal terminal = Terminal.getTerminal();
        if (terminal != null) {
            return terminal.getTerminalWidth();
        }
        return -1;
    }

    @Override
    public String readPassword(String string) {
        try {
            return this.reader.readLine(string, Character.valueOf('*'));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String readLine(String string) {
        try {
            return this.reader.readLine(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void shutdown() {
        History history = this.reader.getHistory();
        if (history != null) {
            FileUtil.closeQuietely(history.getOutput());
        }
    }

    @Override
    public void clearHistory() {
        History history = this.reader.getHistory();
        if (history != null) {
            history.clear();
        }
    }

    @Override
    public void addToHistory(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        History history = this.reader.getHistory();
        if (history != null) {
            for (String string : list) {
                history.addToHistory(string);
            }
        }
    }
}

