/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.sql.formatter.FormatterUtil;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.storage.ResultInfo;
import workbench.util.SqlUtil;

public class DummyDML
implements DbObject {
    public static final String PROP_CONFIG_PREFIX = "workbench.sql.generate.dummydml.";
    public static final String PROP_CONFIG_MAKE_PREPARED = "workbench.sql.generate.dummydml.prepared";
    public static final String PROP_CONFIG_GENERATE_LITERAL = "workbench.sql.generate.dummydml.literal";
    public static final String PLACEHOLDER_COL_NAME = "${column_name}";
    public static final String PLACEHOLDER_TABLE_NAME = "${table_name}";
    protected boolean doFormat;
    protected boolean generatePreparedStatements;
    protected final TableIdentifier table;
    private List<ColumnIdentifier> columns;

    protected DummyDML(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier;
        this.generatePreparedStatements = Settings.getInstance().getBoolProperty(PROP_CONFIG_MAKE_PREPARED, false);
    }

    public DummyDML(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        this.table = tableIdentifier;
        this.columns = new ArrayList<ColumnIdentifier>(list);
        this.generatePreparedStatements = Settings.getInstance().getBoolProperty(PROP_CONFIG_MAKE_PREPARED, false);
    }

    public void setDoFormatSql(boolean bl) {
        this.doFormat = bl;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectExpression(wbConnection);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return null;
    }

    @Override
    public String getObjectName() {
        if (this.table == null) {
            return this.getObjectType();
        }
        return this.table.getTableName();
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return null;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return null;
    }

    @Override
    public String getObjectType() {
        throw new UnsupportedOperationException("Must be implemented in a descendant");
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        throw new UnsupportedOperationException("Must be implemented in a descendant");
    }

    protected List<ColumnIdentifier> getColumns(WbConnection wbConnection) throws SQLException {
        if (this.columns != null) {
            return this.columns;
        }
        ResultInfo resultInfo = new ResultInfo(this.table, wbConnection);
        return resultInfo.getColumnList();
    }

    public String getTemplateConfigKey() {
        return PROP_CONFIG_PREFIX + this.getObjectType().toLowerCase() + ".value.template";
    }

    public String getTemplateConfigKeyForType(int n) {
        return this.getTemplateConfigKeyForType(SqlUtil.getTypeName(n).toLowerCase());
    }

    public String getTemplateConfigKeyForType(String string) {
        return PROP_CONFIG_PREFIX + this.getObjectType().toLowerCase() + ".value.template." + string;
    }

    public void setGeneratePreparedStatement(boolean bl) {
        this.generatePreparedStatements = bl;
    }

    protected String getValueString(ColumnIdentifier columnIdentifier) {
        int n;
        if (this.generatePreparedStatements) {
            return "?";
        }
        String string = Settings.getInstance().getProperty(this.getTemplateConfigKey(), "${column_name}_value");
        String string2 = Settings.getInstance().getProperty(this.getTemplateConfigKeyForType(columnIdentifier.getDataType()), string);
        String string3 = FormatterUtil.getIdentifier(SqlUtil.removeObjectQuotes(columnIdentifier.getColumnName()));
        boolean bl = Settings.getInstance().getBoolProperty(PROP_CONFIG_GENERATE_LITERAL, true);
        String string4 = "workbench.sql.generate.dummydml.literal." + SqlUtil.getTypeName(columnIdentifier.getDataType()).toLowerCase();
        boolean bl2 = Settings.getInstance().getBoolProperty(string4, bl);
        String string5 = string2.replace(PLACEHOLDER_COL_NAME, string3);
        if (this.table != null) {
            string5 = string5.replace(PLACEHOLDER_TABLE_NAME, FormatterUtil.getIdentifier(this.table.getRawTableName()));
        }
        if (bl2 && SqlUtil.isCharacterType(n = columnIdentifier.getDataType())) {
            string5 = "'" + string5 + "'";
        }
        return string5;
    }

    protected String getColumnName(ColumnIdentifier columnIdentifier, WbConnection wbConnection) {
        String string = wbConnection.getMetadata().quoteObjectname(columnIdentifier.getColumnName());
        return FormatterUtil.getIdentifier(string);
    }

    protected String formatSql(String string, WbConnection wbConnection) {
        if (this.doFormat) {
            WbSqlFormatter wbSqlFormatter = new WbSqlFormatter((CharSequence)string, wbConnection == null ? null : wbConnection.getDbId());
            if (wbConnection != null) {
                wbSqlFormatter.setCatalogSeparator(wbConnection.getMetadata().getCatalogSeparator());
                wbSqlFormatter.setSchemaSeparator(wbConnection.getMetadata().getSchemaSeparator());
            }
            return wbSqlFormatter.getFormattedSql();
        }
        return string;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

