/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.regex.PatternSyntaxException;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.RegexErrorPositionReader;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleErrorPositionReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.ErrorDescriptor;

public interface ErrorPositionReader {
    public ErrorDescriptor getErrorPosition(WbConnection var1, String var2, Exception var3);

    public String enhanceErrorMessage(String var1, String var2, ErrorDescriptor var3);

    public static class Factory {
        private static final ErrorPositionReader dummyReader = new ErrorPositionReader(){

            @Override
            public ErrorDescriptor getErrorPosition(WbConnection wbConnection, String string, Exception exception) {
                return null;
            }

            @Override
            public String enhanceErrorMessage(String string, String string2, ErrorDescriptor errorDescriptor) {
                return string2;
            }
        };

        public static ErrorPositionReader createPositionReader(WbConnection wbConnection) {
            if (wbConnection == null) {
                return dummyReader;
            }
            DbMetadata dbMetadata = wbConnection.getMetadata();
            DbSettings dbSettings = wbConnection.getDbSettings();
            if (dbSettings == null) {
                return dummyReader;
            }
            if (dbMetadata == null) {
                return dummyReader;
            }
            if (dbMetadata.isOracle()) {
                return new OracleErrorPositionReader();
            }
            String string = dbSettings.getErrorColumnInfoRegex();
            String string2 = dbSettings.getErrorLineInfoRegex();
            String string3 = dbSettings.getErrorPosInfoRegex();
            boolean bl = dbSettings.getErrorPosIsZeroBased();
            if (string3 != null) {
                try {
                    RegexErrorPositionReader regexErrorPositionReader = new RegexErrorPositionReader(string3);
                    regexErrorPositionReader.setNumbersAreOneBased(bl);
                    LogMgr.logDebug(new CallerInfo(){}, "Initialized reader for dbid=" + wbConnection.getDbId() + " using: positionRegex: " + string3);
                    return regexErrorPositionReader;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not initialize regex based reader using positionRegex: " + string3, patternSyntaxException);
                }
            } else if (string != null || string2 != null) {
                try {
                    RegexErrorPositionReader regexErrorPositionReader = new RegexErrorPositionReader(string2, string);
                    regexErrorPositionReader.setNumbersAreOneBased(bl);
                    LogMgr.logDebug(new CallerInfo(){}, "Initialized reader for dbid=" + wbConnection.getDbId() + " using: lineRegex: " + string2 + ", columnRegex:" + string);
                    return regexErrorPositionReader;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not initialize regex based reader using: lineRegex: " + string2 + ", columnRegex:" + string, patternSyntaxException);
                }
            }
            return dummyReader;
        }
    }
}

