/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.db.ConstraintDefinition;
import workbench.db.ConstraintType;
import workbench.util.StringUtil;

public class TableConstraint
extends ConstraintDefinition
implements Comparable<TableConstraint> {
    private String expression;

    public TableConstraint(String string, String string2) {
        super(string);
        this.expression = StringUtil.isNonBlank(string2) ? string2.trim() : null;
        this.setConstraintType(ConstraintType.Check);
        if (this.expression != null && this.expression.toLowerCase().startsWith("exclude")) {
            this.setConstraintType(ConstraintType.Exclusion);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public int compareTo(TableConstraint tableConstraint) {
        if (tableConstraint == null) {
            return -1;
        }
        if (this.isSystemName() && tableConstraint.isSystemName()) {
            return StringUtil.compareStrings(this.expression, tableConstraint.expression, false);
        }
        int n = StringUtil.compareStrings(this.getConstraintName(), tableConstraint.getConstraintName(), true);
        if (n == 0) {
            n = StringUtil.compareStrings(this.expression, tableConstraint.expression, false);
        }
        return n;
    }

    @Override
    public int hashCode() {
        int n = 5;
        n = 19 * n + (this.expression != null ? this.expression.hashCode() : 0);
        return n;
    }

    public boolean expressionIsEqual(TableConstraint tableConstraint) {
        if (tableConstraint == null) {
            return false;
        }
        return StringUtil.equalString(this.expression, tableConstraint.expression);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TableConstraint) {
            return this.compareTo((TableConstraint)object) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getSql();
    }

    public String getSql() {
        StringBuilder stringBuilder = new StringBuilder(50);
        if (StringUtil.isNonBlank(this.getConstraintName()) && !this.isSystemName()) {
            stringBuilder.append("CONSTRAINT ");
            stringBuilder.append(this.getConstraintName());
            stringBuilder.append(' ');
        }
        if (!this.expression.toLowerCase().startsWith("check") && !this.expression.toLowerCase().startsWith("exclude")) {
            stringBuilder.append("CHECK ");
        }
        stringBuilder.append(this.expression);
        return stringBuilder.toString();
    }
}

