/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.TableGrant;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleTableGrantReader;
import workbench.db.redshift.RedshiftTableGrantReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class TableGrantReader {
    public static TableGrantReader createReader(WbConnection wbConnection) {
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata.isOracle()) {
            return new OracleTableGrantReader();
        }
        if (DBID.fromConnection(wbConnection).equals((Object)DBID.Redshift)) {
            return new RedshiftTableGrantReader();
        }
        return new TableGrantReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TableGrant> getTableGrants(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        HashSet<TableGrant> hashSet = new HashSet<TableGrant>();
        ResultSet resultSet = null;
        Set<String> set = wbConnection.getDbSettings().getGrantorsToIgnore();
        Set<String> set2 = wbConnection.getDbSettings().getGranteesToIgnore();
        long l = System.currentTimeMillis();
        try {
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.adjustCase(wbConnection);
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(new CallerInfo(){}, "Calling DatabaseMetaData.getTablePrivileges() using: " + tableIdentifier2.getRawCatalog() + ", " + tableIdentifier2.getRawSchema() + ", " + tableIdentifier2.getRawTableName());
            }
            resultSet = wbConnection.getSqlConnection().getMetaData().getTablePrivileges(tableIdentifier2.getRawCatalog(), tableIdentifier2.getRawSchema(), tableIdentifier2.getRawTableName());
            boolean bl = wbConnection.getDbSettings().useColumnNameForMetadata();
            while (resultSet.next()) {
                String string;
                String string2 = bl ? resultSet.getString("GRANTOR") : resultSet.getString(4);
                if (set.contains(string2) || set2.contains(string = bl ? resultSet.getString("GRANTEE") : resultSet.getString(5))) continue;
                String string3 = bl ? resultSet.getString("PRIVILEGE") : resultSet.getString(6);
                boolean bl2 = StringUtil.stringToBool(bl ? resultSet.getString("IS_GRANTABLE") : resultSet.getString(7));
                TableGrant tableGrant = new TableGrant(string, string3, bl2);
                hashSet.add(tableGrant);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when retrieving table privileges", exception);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Calling DatabaseMetaData.getTablePrivileges() took: " + l2 + "ms");
        return hashSet;
    }

    public StringBuilder getTableGrantSource(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        List<String> list;
        String string;
        Object object;
        Collection<TableGrant> collection = this.getTableGrants(wbConnection, tableIdentifier);
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = collection.size();
        HashMap<Object, ArrayList<String>> hashMap = new HashMap<Object, ArrayList<String>>(n);
        for (TableGrant object22 : collection) {
            object = object22.getGrantee();
            string = object22.getPrivilege();
            if (string == null) continue;
            list = (ArrayList<String>)hashMap.get(object);
            if (list == null) {
                list = new ArrayList<String>();
                hashMap.put(object, (ArrayList<String>)list);
            }
            list.add(string.trim());
        }
        Iterator<Object> iterator = hashMap.entrySet().iterator();
        String string2 = wbConnection.getCurrentUser();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            string = (String)object.getKey();
            if (string2 != null && string2.equalsIgnoreCase(string)) continue;
            list = (List)object.getValue();
            stringBuilder.append("GRANT ");
            stringBuilder.append(StringUtil.listToString(list, ", ", false));
            stringBuilder.append(" ON ");
            stringBuilder.append(tableIdentifier.getTableExpression(wbConnection));
            stringBuilder.append(" TO ");
            stringBuilder.append(string);
            stringBuilder.append(";\n");
        }
        return stringBuilder;
    }
}

