/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.compare;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;

public class BatchedStatement {
    private PreparedStatement statement;
    private int batchSize;
    private int currentSize;
    private boolean commitBatch;
    private final List<Closeable> streams = new ArrayList<Closeable>();

    public BatchedStatement(PreparedStatement preparedStatement, WbConnection wbConnection, int n) {
        this.statement = preparedStatement;
        try {
            this.batchSize = n > 1 && wbConnection.getSqlConnection().getMetaData().supportsBatchUpdates() ? n : 1;
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error initializing statement", sQLException);
            this.batchSize = 1;
        }
        this.currentSize = 0;
    }

    public void cancel() throws SQLException {
        if (this.statement != null) {
            this.statement.cancel();
        }
    }

    public void setCommitBatch(boolean bl) {
        this.commitBatch = bl;
    }

    public void setObject(int n, Object object) throws SQLException {
        this.statement.setObject(n, object);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.statement.setClob(n, clob);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.statement.setBytes(n, byArray);
    }

    public void setString(int n, String string) throws SQLException {
        this.statement.setString(n, string);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.statement.setObject(n, object, n2);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.statement.setDate(n, date);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.statement.setTimestamp(n, timestamp);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.statement.setNull(n, n2);
    }

    public void setXML(int n, SQLXML sQLXML) throws SQLException {
        this.statement.setSQLXML(n, sQLXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.statement.setCharacterStream(n, reader, n2);
        List<Closeable> list = this.streams;
        synchronized (list) {
            this.streams.add(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.statement.setCharacterStream(n, reader, l);
        List<Closeable> list = this.streams;
        synchronized (list) {
            this.streams.add(reader);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.statement.setBlob(n, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.statement.setBinaryStream(n, inputStream, n2);
        List<Closeable> list = this.streams;
        synchronized (list) {
            this.streams.add(inputStream);
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    protected long addBatch() throws SQLException {
        long l = 0L;
        if (this.batchSize == 1) {
            l = this.statement.executeUpdate();
            this.closeStreams();
        } else {
            this.statement.addBatch();
            ++this.currentSize;
            if (this.currentSize == this.batchSize) {
                l = this.runBatch();
            }
        }
        return l;
    }

    private long runBatch() throws SQLException {
        int[] nArray = this.statement.executeBatch();
        this.currentSize = 0;
        if (nArray == null) {
            return 0L;
        }
        long l = 0L;
        for (int n : nArray) {
            if (n == -2) {
                ++l;
                continue;
            }
            l += (long)n;
        }
        if (this.commitBatch) {
            this.statement.getConnection().commit();
        }
        this.statement.clearBatch();
        this.closeStreams();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStreams() {
        List<Closeable> list = this.streams;
        synchronized (list) {
            FileUtil.closeStreams(this.streams);
            this.streams.clear();
        }
    }

    public long executeUpdate() throws SQLException {
        return this.addBatch();
    }

    public long flush() throws SQLException {
        if (this.currentSize > 0) {
            return this.runBatch();
        }
        return 0L;
    }

    public void close() {
        try {
            this.statement.clearBatch();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JdbcUtils.closeStatement(this.statement);
        this.closeStreams();
    }

    public String toString() {
        if (this.statement != null) {
            return this.statement.toString();
        }
        return "";
    }
}

