/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.ControlFileFormat;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.FormatFileWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.storage.RowData;
import workbench.storage.reader.ResultSetHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.Alias;
import workbench.util.FileUtil;
import workbench.util.LowMemoryException;
import workbench.util.MemoryWatcher;
import workbench.util.SqlUtil;
import workbench.util.WbFile;

public abstract class ExportWriter {
    protected DataExporter exporter;
    protected boolean cancel = false;
    protected long rows;
    protected String tableToUse;
    protected RowActionMonitor rowMonitor;
    protected RowDataConverter converter;
    protected Writer outputWriter;
    protected WbFile outputFile;
    protected boolean canAppendStart;
    protected boolean trimCharData;
    protected boolean useStreamsForBlobs;
    protected boolean useStreamsForClobs;
    private int progressInterval = 10;

    public ExportWriter(DataExporter dataExporter) {
        this.exporter = dataExporter;
        this.converter = this.createConverter();
        WbConnection wbConnection = this.exporter.getConnection();
        this.converter.setOriginalConnection(wbConnection);
        this.configureConverter();
        if (wbConnection != null) {
            this.useStreamsForBlobs = wbConnection.getDbSettings().getUseStreamsForBlobExport();
            this.useStreamsForClobs = wbConnection.getDbSettings().getUseStreamsForClobExport();
        }
    }

    public void configureConverter() {
        this.converter.setErrorReporter(this.exporter);
        this.converter.setExporter(this.exporter);
        this.converter.setEncoding(this.exporter.getEncoding());
        this.converter.setDefaultDateFormatter(this.exporter.getDateFormatter());
        this.converter.setDefaultTimestampFormatter(this.exporter.getTimestampFormatter());
        this.converter.setDefaultTimeFormatter(this.exporter.getTimeFormatter());
        this.converter.setDefaultNumberFormatter(this.exporter.getDecimalFormatter());
        this.converter.setColumnsToExport(this.exporter.getColumnsToExport());
        this.converter.setCompressExternalFiles(this.exporter.getCompressOutput());
        this.converter.setBlobIdColumns(this.exporter.getBlobIdColumns());
        this.converter.setFilenameColumn(this.exporter.getFilenameColumn());
        this.converter.setPageTitle(this.exporter.getPageTitle());
        this.converter.setWriteHeader(this.exporter.getExportHeaders());
        this.converter.setAppendInfoSheet(this.exporter.getAppendInfoSheet());
        this.converter.setEnableAutoFilter(this.exporter.getEnableAutoFilter());
        this.converter.setEnableFixedHeader(this.exporter.getEnableFixedHeader());
        this.converter.setDataModifier(this.exporter.getDataModifier());
        this.converter.setIncludeColumnComments(this.exporter.getIncludeColumnComments());
        this.converter.setMaxLobFilesPerDirectory(this.exporter.getMaxLobFilesPerDirectory());
        this.converter.setInfinityLiterals(this.exporter.getInfinityLiterals());
        this.trimCharData = this.exporter.getTrimCharData();
    }

    public abstract RowDataConverter createConverter();

    public void setProgressInterval(int n) {
        this.progressInterval = n <= 0 ? 0 : n;
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    public long getNumberOfRecords() {
        return this.rows;
    }

    public void writeExport(DataStore dataStore, List<ColumnIdentifier> list) throws SQLException, IOException {
        ResultInfo resultInfo = dataStore.getResultInfo();
        this.converter.setGeneratingSql(dataStore.getGeneratingSql());
        this.converter.setResultInfo(resultInfo);
        this.converter.setColumnsToExport(list);
        if (this.converter.needsUpdateTable() || !this.exporter.getControlFileFormats().isEmpty()) {
            dataStore.checkUpdateTable();
        }
        this.cancel = false;
        this.rows = 0L;
        this.startProgress();
        this.writeStart();
        int n = dataStore.getRowCount();
        for (int i = 0; i < n && !this.cancel; ++i) {
            this.updateProgress(this.rows);
            RowData rowData = dataStore.getRow(i);
            this.writeRow(rowData, this.rows);
            ++this.rows;
        }
        this.writeEnd(this.rows);
    }

    public boolean managesOutput() {
        return false;
    }

    public void setOutputFile(WbFile wbFile) {
        this.outputFile = wbFile;
        this.converter.setOutputFile(wbFile);
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void writeExport(ResultSet resultSet, ResultInfo resultInfo, String string) throws SQLException, IOException {
        List<Alias> list;
        this.converter.setResultInfo(resultInfo);
        this.converter.setGeneratingSql(string);
        this.cancel = false;
        this.rows = 0L;
        if ((this.converter.needsUpdateTable() || !this.exporter.getControlFileFormats().isEmpty()) && (list = SqlUtil.getTables(string, false, this.exporter.getConnection())).size() > 0) {
            resultInfo.setUpdateTable(new TableIdentifier(list.get(0).getObjectName(), this.exporter.getConnection()));
        }
        this.startProgress();
        boolean bl = true;
        if (this.exporter.writeEmptyResults()) {
            this.writeStart();
        }
        RowDataReader rowDataReader = RowDataReaderFactory.createReader(resultInfo, this.exporter.getConnection());
        rowDataReader.setUseStreamsForBlobs(this.useStreamsForBlobs);
        rowDataReader.setUseStreamsForClobs(this.useStreamsForClobs);
        int n = Settings.getInstance().getLowMemoryCheckInterval();
        ResultSetHolder resultSetHolder = new ResultSetHolder(resultSet);
        while (resultSet.next() && !this.cancel) {
            if (bl) {
                bl = false;
                if (!this.exporter.writeEmptyResults()) {
                    this.writeStart();
                }
            }
            this.updateProgress(this.rows);
            RowData rowData = rowDataReader.read(resultSetHolder, this.trimCharData);
            this.writeRow(rowData, this.rows);
            rowDataReader.closeStreams();
            ++this.rows;
            if (this.rows % (long)n != 0L || !MemoryWatcher.isMemoryLow(false)) continue;
            LogMgr.logError(new CallerInfo(){}, "Memory is running low. Aborting export...", null);
            throw new LowMemoryException();
        }
        if (this.rows > 0L || this.exporter.writeEmptyResults()) {
            this.writeEnd(this.rows);
        }
    }

    protected void startProgress() {
        if (this.rowMonitor != null && this.progressInterval > 0) {
            this.rowMonitor.setMonitorType(3);
        }
    }

    protected void updateProgress(long l) {
        if (this.rowMonitor != null && this.progressInterval > 0 && (l == 1L || this.rows % (long)this.progressInterval == 0L)) {
            this.rowMonitor.setCurrentRow((int)l, -1L);
        }
    }

    protected void writeRow(RowData rowData, long l) throws IOException {
        this.converter.applyDataModifier(rowData, l);
        StringBuilder stringBuilder = this.converter.convertRowData(rowData, l);
        if (stringBuilder != null && this.outputWriter != null) {
            this.outputWriter.append(stringBuilder);
        }
    }

    protected void writeStart() throws IOException {
        boolean bl = true;
        if (this.exporter.getAppendToFile()) {
            bl = this.canAppendStart;
            if (this.outputFile != null && !this.canAppendStart) {
                boolean bl2 = bl = !this.outputFile.exists() || this.outputFile.length() == 0L;
            }
        }
        if (!bl) {
            return;
        }
        this.writeFormatFile();
        StringBuilder stringBuilder = this.converter.getStart();
        if (stringBuilder != null && this.outputWriter != null) {
            this.outputWriter.append(stringBuilder);
        }
    }

    protected void writeEnd(long l) throws IOException {
        StringBuilder stringBuilder = this.converter.getEnd(l);
        if (stringBuilder != null && this.outputWriter != null) {
            this.outputWriter.append(stringBuilder);
        }
    }

    public void exportStarting() throws IOException {
    }

    public long exportFinished() {
        FileUtil.closeQuietely(this.outputWriter);
        try {
            if (this.converter != null) {
                this.converter.exportFinished();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error closing output stream", exception);
            return -1L;
        }
        return this.rows;
    }

    public void cancel() {
        this.cancel = true;
    }

    public void setTableToUse(String string) {
        this.tableToUse = string;
    }

    protected void writeFormatFile() {
        Set<ControlFileFormat> set = this.exporter.getControlFileFormats();
        for (ControlFileFormat controlFileFormat : set) {
            FormatFileWriter formatFileWriter = ControlFileFormat.createFormatWriter(controlFileFormat);
            boolean bl = Settings.getInstance().getBoolProperty("workbench.db.exporter.formatfile." + controlFileFormat.name() + ".fullpath", false);
            formatFileWriter.setUseFullFilepath(bl);
            formatFileWriter.writeFormatFile(this.exporter, this.converter);
        }
    }

    public RowDataConverter getConverter() {
        return this.converter;
    }
}

