/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.regex.Matcher;
import workbench.db.exporter.OdsDateStyleBuilder;
import workbench.db.exporter.RowDataConverter;
import workbench.db.report.TagWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.RowData;
import workbench.util.FileUtil;
import workbench.util.HtmlUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;
import workbench.util.ZipOutputFactory;

public class OdsRowDataConverter
extends RowDataConverter {
    private Writer content;
    private WbDateFormatter tFormat = new WbDateFormatter("HH:mm:ss");
    private WbDateFormatter dtFormat = new WbDateFormatter("yyyy-MM-dd");
    private WbDateFormatter tsFormat = new WbDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
    private final String dateStyle = "ce2";
    private final String tsStyle = "ce3";
    private final String timeStyle = "ce4";

    @Override
    public StringBuilder getStart() {
        try {
            int n;
            if (this.factory != null) {
                this.factory.done();
            }
            this.factory = new ZipOutputFactory(this.getOutputFile());
            boolean bl = this.isTemplate();
            if (bl) {
                this.factory.writeUncompressedString("mimetype", "application/vnd.oasis.opendocument.spreadsheet-template");
            } else {
                this.factory.writeUncompressedString("mimetype", "application/vnd.oasis.opendocument.spreadsheet");
            }
            Writer writer = this.factory.createWriter("META-INF/manifest.xml", "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\" manifest:version=\"1.2\">\n");
            if (bl) {
                writer.write(" <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument.spreadsheet-template\" manifest:full-path=\"/\"/>\n");
            } else {
                writer.write(" <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument.spreadsheet\" manifest:full-path=\"/\"/>\n");
            }
            writer.write(" <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/>\n");
            writer.write(" <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"meta.xml\"/>\n");
            writer.write(" <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"settings.xml\"/>\n");
            writer.write(" <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/>\n");
            writer.write("</manifest:manifest>\n");
            writer.close();
            this.writeMeta();
            this.writeStyles();
            if (this.getEnableFixedHeader() && (this.writeHeader || this.includeColumnComments)) {
                this.writeSettings();
            }
            this.content = this.factory.createWriter("content.xml", "UTF-8");
            this.content.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n");
            this.content.write("<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"https://www.w3.org/1999/xlink\" xmlns:dc=\"https://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"https://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"https://openoffice.org/2004/office\" xmlns:ooow=\"https://openoffice.org/2004/writer\" xmlns:oooc=\"https://openoffice.org/2004/calc\" xmlns:dom=\"https://www.w3.org/2001/xml-events\" xmlns:xforms=\"https://www.w3.org/2002/xforms\" xmlns:xsd=\"https://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\" office:version=\"1.2\"> \n");
            this.writeInlineStyles();
            this.content.write("<office:body>\n");
            this.content.write("<office:spreadsheet> \n");
            this.content.write("<table:table table:name=\"" + this.getPageTitle("Export") + "\"  table:style-name=\"ta1\">\n\n");
            int n2 = this.metaData.getColumnCount();
            for (n = 0; n < n2; ++n) {
                if (!this.includeColumnInExport(n)) continue;
                int n3 = this.getResultInfo().getColumnType(n);
                String string = "Default";
                if (n3 == 91) {
                    string = "ce2";
                } else if (n3 == 93) {
                    string = "ce3";
                } else if (n3 == 92) {
                    string = "ce4";
                }
                this.content.write("<table:table-column table:style-name=\"co" + (n + 1) + "\" table:default-cell-style-name=\"" + string + "\"/>\n");
            }
            if (this.includeColumnComments) {
                this.content.write("<table:table-header-rows>\n");
                this.content.write("  <table:table-row table:style-name=\"ro1\">\n");
                for (n = 0; n < n2; ++n) {
                    if (!this.includeColumnInExport(n)) continue;
                    String string = this.metaData.getColumn(n).getComment();
                    this.content.write("  <table:table-cell table:style-name=\"ce1\" office:value-type=\"string\">\n");
                    this.content.write("    <text:p>");
                    this.appendValue(this.content, string);
                    this.content.write("</text:p>\n");
                    this.content.write("  </table:table-cell>\n");
                }
                this.content.write("  </table:table-row>\n");
                this.content.write("</table:table-header-rows>\n\n");
            }
            if (this.writeHeader) {
                this.content.write("<table:table-header-rows>\n");
                this.content.write("  <table:table-row table:style-name=\"ro1\">\n");
                for (n = 0; n < n2; ++n) {
                    if (!this.includeColumnInExport(n)) continue;
                    String string = SqlUtil.removeObjectQuotes(this.metaData.getColumnDisplayName(n));
                    this.content.write("  <table:table-cell table:style-name=\"ce1\" office:value-type=\"string\">\n");
                    this.content.write("    <text:p>");
                    this.appendValue(this.content, string);
                    this.content.write("</text:p>\n");
                    this.content.write("  </table:table-cell>\n");
                }
                this.content.write("  </table:table-row>\n");
                this.content.write("</table:table-header-rows>\n\n");
            }
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error creating archive!", iOException);
        }
        return null;
    }

    private void appendValue(Writer writer, String string) throws IOException {
        boolean bl = TagWriter.needsCData(string);
        if (bl) {
            writer.write("<![CDATA[");
        }
        writer.write(string);
        if (bl) {
            writer.write("]]>");
        }
    }

    private void writeStyles() {
        String string = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<office:document-styles xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" \n                        xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" \n                        office:version=\"1.2\">\n  <office:master-styles>\n    <style:master-page style:name=\"Default\" style:page-layout-name=\"Mpm1\">\n      <style:header/>\n      <style:footer/>\n    </style:master-page>\n  </office:master-styles>\n</office:document-styles>";
        try (Writer writer = this.factory.createWriter("styles.xml", "UTF-8");){
            writer.write(string);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error writing styles", exception);
        }
    }

    private void writeSettings() {
        Writer writer = null;
        try {
            String string = this.includeColumnComments ? "2" : "1";
            writer = this.factory.createWriter("settings.xml", "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            writer.write("<office:document-settings xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" \n");
            writer.write("    xmlns:xlink=\"https://www.w3.org/1999/xlink\"     xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\"     xmlns:ooo=\"https://openoffice.org/2004/office\" office:version=\"1.2\">");
            writer.write("  <office:settings>\n");
            writer.write("    <config:config-item-set config:name=\"ooo:view-settings\">\n");
            writer.write("      <config:config-item-map-indexed config:name=\"Views\">\n");
            writer.write("        <config:config-item-map-entry>\n");
            writer.write("          <config:config-item config:name=\"ViewId\" config:type=\"string\">View1</config:config-item>\n");
            writer.write("          <config:config-item-map-named config:name=\"Tables\">\n");
            writer.write("            <config:config-item-map-entry config:name=\"" + this.getPageTitle("Export") + "\">\n");
            writer.write("              <config:config-item config:name=\"CursorPositionX\" config:type=\"int\">0</config:config-item>\n");
            writer.write("              <config:config-item config:name=\"CursorPositionY\" config:type=\"int\">" + string + "</config:config-item>\n");
            writer.write("              <config:config-item config:name=\"VerticalSplitMode\" config:type=\"short\">2</config:config-item>\n");
            writer.write("              <config:config-item config:name=\"VerticalSplitPosition\" config:type=\"int\">" + string + "</config:config-item>\n");
            writer.write("              <config:config-item config:name=\"ActiveSplitRange\" config:type=\"short\">2</config:config-item>\n");
            writer.write("              <config:config-item config:name=\"PositionBottom\" config:type=\"int\">" + string + "</config:config-item>\n");
            writer.write("            </config:config-item-map-entry>\n");
            writer.write("          </config:config-item-map-named>\n");
            writer.write("        </config:config-item-map-entry>\n");
            writer.write("      </config:config-item-map-indexed>\n");
            writer.write("    </config:config-item-set>\n");
            writer.write("  </office:settings>\n");
            writer.write("</office:document-settings>\n");
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error writing settings", exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(writer);
                throw throwable;
            }
            FileUtil.closeQuietely(writer);
        }
        FileUtil.closeQuietely(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMeta() {
        Writer writer = null;
        try {
            String string;
            writer = this.factory.createWriter("meta.xml", "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            writer.write("<office:document-meta \n     office:version=\"1.2\" \n     xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" \n     xmlns:xlink=\"https://www.w3.org/1999/xlink\" \n     xmlns:dc=\"http://purl.org/dc/elements/1.1/\" \n     xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" \n     xmlns:ooo=\"https://openoffice.org/2004/office\">\n");
            writer.write("<office:meta>\n");
            writer.write("<meta:generator>SQL Workbench/J</meta:generator>\n");
            writer.write("<dc:title>SQL Workbench/J Export</dc:title>\n");
            if (this.generatingSql != null) {
                Matcher matcher = StringUtil.PATTERN_CRLF.matcher(this.generatingSql);
                string = matcher.replaceAll(" ");
            } else {
                string = "SELECT * FROM " + this.metaData.getUpdateTable().getTableExpression(this.originalConnection);
            }
            writer.write("<dc:description>");
            writer.write("<![CDATA[");
            writer.write(string);
            writer.write("]]>");
            writer.write("</dc:description>");
            writer.write("<meta:initial-creator>SQL Workbench/J</meta:initial-creator>\n");
            writer.write("<meta:creation-date>");
            writer.write(this.tsFormat.formatUtilDate(new Date()));
            writer.write("</meta:creation-date>\n");
            writer.write("</office:meta>\n");
            writer.write("</office:document-meta>\n");
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error writing meta data", exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(writer);
                throw throwable;
            }
            FileUtil.closeQuietely(writer);
        }
        FileUtil.closeQuietely(writer);
    }

    private void writeInlineStyles() throws IOException {
        this.content.write("<office:automatic-styles> \n");
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            this.content.write("  <style:style style:name=\"co" + (i + 1) + "\" style:family=\"table-column\"> \n");
            this.content.write("    <style:table-column-properties style:use-optimal-column-width=\"true\"/> \n");
            this.content.write("  </style:style> \n");
        }
        String string = this.timestampIncluded() ? this.buildDateStyle(new OdsDateStyleBuilder(this.defaultTimestampFormatter.getPatternWithoutTimeZone()), "ce3", "N50") : "";
        String string2 = this.dateIncluded() ? this.buildDateStyle(new OdsDateStyleBuilder(this.defaultDateFormatter.toPattern()), "ce2", "N60") : "";
        String string3 = this.timeIncluded() ? this.buildDateStyle(new OdsDateStyleBuilder(this.defaultTimeFormatter.toPattern()), "ce2", "N80") : "";
        String string4 = "  <style:style style:name=\"ro1\" style:family=\"table-row\"> \n    <style:table-row-properties fo:break-before=\"auto\" style:row-height=\"5.00mm\" style:use-optimal-row-height=\"true\"/> \n  </style:style> \n  <style:style style:name=\"ta1\" style:family=\"table\" style:master-page-name=\"Default\"> \n    <style:table-properties table:display=\"true\" style:writing-mode=\"lr-tb\"/> \n  </style:style> \n  <style:style style:name=\"ce1\" style:family=\"table-cell\" style:parent-style-name=\"Default\"> \n    <style:text-properties fo:font-weight=\"bold\" style:font-weight-asian=\"bold\" style:font-weight-complex=\"bold\"/> \n  </style:style> \n" + string2 + string + string3 + "</office:automatic-styles>\n";
        this.content.write(string4);
    }

    private boolean timestampIncluded() {
        return this.typeStyleNeeded(93);
    }

    private boolean dateIncluded() {
        return this.typeStyleNeeded(91);
    }

    private boolean timeIncluded() {
        return this.typeStyleNeeded(92);
    }

    private boolean typeStyleNeeded(int n) {
        int n2 = this.metaData.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!this.includeColumnInExport(i) || (n3 = this.getResultInfo().getColumnType(i)) != n) continue;
            return true;
        }
        return false;
    }

    private String buildDateStyle(OdsDateStyleBuilder odsDateStyleBuilder, String string, String string2) {
        String string3 = "  <number:date-style style:name=\"" + string2 + "\">\n" + odsDateStyleBuilder.getXML("    ") + "  </number:date-style>\n";
        string3 = string3 + "  <style:style style:name=\"" + string + "\" style:family=\"table-cell\" style:parent-style-name=\"Default\" style:data-style-name=\"" + string2 + "\"/>\n";
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringBuilder getEnd(long l) {
        try {
            CharSequence charSequence;
            String[] stringArray;
            this.content.write("</table:table>\n");
            if (this.getAppendInfoSheet()) {
                this.content.write("<table:table table:name=\"SQL\" table:style-name=\"ta1\">\n");
                this.content.append("<table:table-row>\n");
                this.content.append("<table:table-cell office:value-type=\"string\">");
                stringArray = this.generatingSql.split("((\r\n)|(\n\r)|\r|\n)");
                charSequence = new StringBuilder(this.generatingSql.length() + 50);
                for (String string : stringArray) {
                    ((StringBuilder)charSequence).append("<text:p>");
                    this.writeEscapedXML((StringBuilder)charSequence, string);
                    ((StringBuilder)charSequence).append("</text:p>\n");
                }
                this.content.append(((StringBuilder)charSequence).toString());
                this.content.append("</table:table-cell>");
                this.content.append("</table:table-row>\n");
                this.content.write("</table:table>");
            }
            if (this.getEnableAutoFilter() && this.writeHeader) {
                void var5_8;
                stringArray = this.columnToName(this.getRealColumnCount());
                charSequence = "&apos;" + HtmlUtil.escapeXML(this.getPageTitle("Export"), false) + "&apos;";
                String string = "A1";
                if (this.includeColumnComments) {
                    String string2 = "A2";
                }
                this.content.append("<table:database-ranges>\n");
                this.content.append("<table:database-range table:target-range-address=\"" + (String)charSequence + "." + (String)var5_8 + ":" + (String)charSequence + "." + (String)stringArray + Long.toString(l) + "\" table:display-filter-buttons=\"true\" />\n");
                this.content.append("</table:database-ranges>\n");
            }
            this.content.write("</office:spreadsheet> \n");
            this.content.write("</office:body>\n");
            this.content.write("</office:document-content>\n");
            this.content.close();
            this.factory.done();
            this.factory = null;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error writing end of worksheet", exception);
        }
        return null;
    }

    protected String columnToName(int n) {
        StringBuilder stringBuilder = new StringBuilder(3);
        int n2 = n;
        while (n2 > 0) {
            int n3 = (n2 - 1) % 26;
            char c = (char)(65 + (char)n3);
            stringBuilder.insert(0, c);
            n2 = (n2 - n3) / 26;
        }
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        int n = rowData.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(n * 50);
        stringBuilder.append("<table:table-row>\n");
        for (int i = 0; i < n; ++i) {
            if (!this.includeColumnInExport(i)) continue;
            Object object = rowData.getValue(i);
            String string = this.getValueAsFormattedString(rowData, i);
            if (string == null && this.getNullDisplay() != null) {
                string = this.getNullDisplay();
            }
            if (object == null && StringUtil.isEmptyString(string)) {
                stringBuilder.append("<table:table-cell />");
                continue;
            }
            stringBuilder.append("<table:table-cell ");
            stringBuilder.append((CharSequence)this.getCellAttribs(object, i));
            stringBuilder.append(">\n");
            if (SqlUtil.isCharacterType(this.metaData.getColumnType(i))) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("((\r\n)|(\n\r)|\r|\n)")) {
                    stringBuilder.append("<text:p>");
                    this.writeEscapedXML(stringBuilder, string2);
                    stringBuilder.append("</text:p>\n");
                }
            } else {
                stringBuilder.append("<text:p>");
                stringBuilder.append(string);
                stringBuilder.append("</text:p>\n");
            }
            stringBuilder.append("</table:table-cell>\n");
        }
        stringBuilder.append("</table:table-row>\n\n");
        try {
            this.content.append(stringBuilder);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Error writing row " + l, iOException);
        }
        return null;
    }

    private StringBuilder getCellAttribs(Object object, int n) {
        StringBuilder stringBuilder = new StringBuilder("office:value-type=");
        int n2 = this.metaData.getColumnType(n);
        if (SqlUtil.isNumberType(n2)) {
            stringBuilder.append("\"float\" ");
            stringBuilder.append(" office:value=\"");
            stringBuilder.append(object.toString());
            stringBuilder.append("\"");
        } else if (n2 == 91) {
            stringBuilder.append("\"date\" table:style-name=\"ce2\" office:date-value=\"");
            stringBuilder.append(this.dtFormat.formatDateTimeValue(object));
            stringBuilder.append("\"");
        } else if (n2 == 93) {
            stringBuilder.append("\"date\" table:style-name=\"ce3\" office:date-value=\"");
            stringBuilder.append(this.tsFormat.formatDateTimeValue(object));
            stringBuilder.append("\"");
        } else if (n2 == 92) {
            stringBuilder.append("\"date\" office:time-value=\"");
            stringBuilder.append(this.tFormat.formatDateTimeValue(object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append("\"string\"");
        }
        return stringBuilder;
    }

    public boolean isTemplate() {
        return this.hasOutputFileExtension("ots");
    }
}

