/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import workbench.db.TableIdentifier;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.db.exporter.SqlRowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class SqlExportWriter
extends ExportWriter {
    public SqlExportWriter(DataExporter dataExporter) {
        super(dataExporter);
        this.canAppendStart = true;
    }

    @Override
    public RowDataConverter createConverter() {
        return new SqlRowDataConverter(this.exporter.getConnection());
    }

    @Override
    public void configureConverter() {
        String string;
        super.configureConverter();
        SqlRowDataConverter sqlRowDataConverter = (SqlRowDataConverter)this.converter;
        sqlRowDataConverter.setIncludeTableOwner(this.exporter.getUseSchemaInSql());
        sqlRowDataConverter.setCommitEvery(this.exporter.getCommitEvery());
        sqlRowDataConverter.setChrFunction(this.exporter.getChrFunction());
        sqlRowDataConverter.setConcatString(this.exporter.getConcatString());
        sqlRowDataConverter.setConcatFunction(this.exporter.getConcatFunction());
        sqlRowDataConverter.setDateLiteralType(this.exporter.getDateLiteralType());
        sqlRowDataConverter.setLineEnding(this.exporter.getLineEnding());
        sqlRowDataConverter.setBlobMode(this.exporter.getBlobMode());
        if (this.exporter.getWriteClobAsFile()) {
            string = this.exporter.getEncoding();
            if (string == null) {
                string = Settings.getInstance().getDefaultFileEncoding();
            }
            sqlRowDataConverter.setClobAsFile(string, this.exporter.getClobSizeThreshold());
        }
        sqlRowDataConverter.setKeyColumnsToUse(this.exporter.getKeyColumnsToUse());
        try {
            sqlRowDataConverter.setType(this.exporter.getExportType());
            sqlRowDataConverter.setMergeType(this.exporter.getMergeType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogMgr.logError(new CallerInfo(){}, "Illegal SQL type requested. Reverting to INSERT", null);
            sqlRowDataConverter.setCreateInsert();
        }
        switch (this.exporter.getExportType()) {
            case SQL_INSERT: 
            case SQL_DELETE_INSERT: 
            case SQL_INSERT_IGNORE: {
                sqlRowDataConverter.setApplySQLFormatting(Settings.getInstance().getDoFormatInserts());
            }
            case SQL_UPDATE: {
                sqlRowDataConverter.setApplySQLFormatting(Settings.getInstance().getDoFormatUpdates());
            }
            case SQL_DELETE: {
                sqlRowDataConverter.setApplySQLFormatting(Settings.getInstance().getDoFormatDeletes());
            }
        }
        sqlRowDataConverter.setApplySQLFormatting(false);
        string = this.exporter.getTableName();
        if (string != null) {
            sqlRowDataConverter.setAlternateUpdateTable(new TableIdentifier(string, this.exporter.getConnection()));
        }
        sqlRowDataConverter.setCreateTable(this.exporter.isIncludeCreateTable());
    }
}

