/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.text.SimpleDateFormat;
import java.util.Date;
import workbench.db.exporter.RowDataConverter;
import workbench.storage.RowData;
import workbench.util.EncodingUtil;
import workbench.util.HtmlUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class XlsXMLRowDataConverter
extends RowDataConverter {
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public StringBuilder getStart() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(5000);
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"" + EncodingUtil.cleanupEncoding(this.getEncoding()) + "\"?>\n");
        stringBuilder.append("<?mso-application progid=\"Excel.Sheet\"?>\n");
        stringBuilder.append("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\" xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\" xmlns:html=\"https://www.w3.org/TR/REC-html40\">\n");
        stringBuilder.append("<DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\">\n");
        stringBuilder.append("<LastAuthor>SQL Workbench/J</LastAuthor>\n");
        stringBuilder.append("<Created>");
        stringBuilder.append(this.tsFormat.format(new Date()));
        stringBuilder.append("</Created>\n");
        stringBuilder.append("</DocumentProperties>\n");
        stringBuilder.append("<Styles>\n");
        if (this.writeHeader) {
            stringBuilder.append("  <Style ss:ID=\"wbHeader\"><Font ss:Bold=\"1\"/></Style>\n");
        }
        stringBuilder.append("  <Style ss:ID=\"wbTS\"><NumberFormat ss:Format=\"" + this.getDateFormat() + "\"/></Style>\n");
        stringBuilder.append("  <Style ss:ID=\"wbML\"><Alignment ss:Vertical=\"Top\" ss:WrapText=\"1\"/></Style>\n");
        stringBuilder.append("  <Style ss:ID=\"wbNW\"><Alignment ss:Vertical=\"Top\" ss:WrapText=\"0\"/></Style>\n");
        stringBuilder.append("</Styles>\n");
        int n2 = this.metaData.getColumnCount();
        stringBuilder.append("<Worksheet ss:Name=\"" + HtmlUtil.escapeXML(this.getPageTitle("Export"), false) + "\">\n");
        stringBuilder.append("<Table ss:ExpandedColumnCount=\"" + this.getRealColumnCount() + "\" x:FullColumns=\"1\" x:FullRows=\"1\">\n");
        for (n = 0; n < n2; ++n) {
            if (!this.includeColumnInExport(n)) continue;
            stringBuilder.append("<Column ss:AutoFitWidth=\"1\"/>\n");
        }
        if (this.includeColumnComments) {
            stringBuilder.append("<Row>\n");
            for (n = 0; n < n2; ++n) {
                if (!this.includeColumnInExport(n)) continue;
                stringBuilder.append("  <Cell ss:StyleID=\"wbHeader\"><Data ss:Type=\"String\">");
                stringBuilder.append("<![CDATA[");
                stringBuilder.append(this.metaData.getColumn(n).getComment());
                stringBuilder.append("]]>");
                stringBuilder.append("</Data></Cell>\n");
            }
            stringBuilder.append("</Row>");
        }
        if (this.writeHeader) {
            stringBuilder.append("<Row>\n");
            for (n = 0; n < n2; ++n) {
                if (!this.includeColumnInExport(n)) continue;
                stringBuilder.append("  <Cell ss:StyleID=\"wbHeader\"><Data ss:Type=\"String\">");
                stringBuilder.append(SqlUtil.removeObjectQuotes(this.metaData.getColumnDisplayName(n)));
                stringBuilder.append("</Data></Cell>\n");
            }
            stringBuilder.append("</Row>");
        }
        stringBuilder.append('\n');
        return stringBuilder;
    }

    @Override
    public StringBuilder getEnd(long l) {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("</Table>\n");
        if (this.getEnableFixedHeader() && this.writeHeader) {
            stringBuilder.append("<WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\n");
            stringBuilder.append("  <Selected/>\n<FreezePanes/>\n<FrozenNoSplit/>\n");
            stringBuilder.append("  <SplitHorizontal>1</SplitHorizontal>\n<TopRowBottomPane>1</TopRowBottomPane>\n<ActivePane>2</ActivePane>\n");
            stringBuilder.append("</WorksheetOptions>\n");
        }
        if (this.getEnableAutoFilter() && this.writeHeader) {
            stringBuilder.append("<AutoFilter x:Range=\"R1C1:R1C" + this.getRealColumnCount() + "\" xmlns=\"urn:schemas-microsoft-com:office:excel\"></AutoFilter>\n");
        }
        stringBuilder.append("</Worksheet>\n");
        if (this.getAppendInfoSheet()) {
            stringBuilder.append("<Worksheet ss:Name=\"SQL\">\n");
            stringBuilder.append("  <Table ss:ExpandedColumnCount=\"1\">\n");
            stringBuilder.append("    <Row>\n");
            stringBuilder.append("      <Cell ss:StyleID=\"wbNW\"><Data ss:Type=\"String\">");
            stringBuilder.append("<![CDATA[");
            stringBuilder.append(this.generatingSql);
            stringBuilder.append("]]>");
            stringBuilder.append("      </Data></Cell>");
            stringBuilder.append("    </Row>\n");
            stringBuilder.append("  </Table>\n");
            stringBuilder.append("</Worksheet>\n");
        }
        stringBuilder.append("</Workbook>\n");
        return stringBuilder;
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        int n = rowData.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(n * 50);
        stringBuilder.append("<Row>\n");
        for (int i = 0; i < n; ++i) {
            boolean bl;
            if (!this.includeColumnInExport(i)) continue;
            boolean bl2 = rowData.getValue(i) instanceof Date;
            String string = null;
            if (bl2) {
                Date date = (Date)rowData.getValue(i);
                string = this.tsFormat.format(date);
            } else {
                string = this.getValueAsFormattedString(rowData, i);
                if (string == null) {
                    string = this.getNullDisplay();
                }
            }
            boolean bl3 = string == null ? false : (bl = string.indexOf(10) > 0);
            if (bl2) {
                stringBuilder.append("  <Cell ss:StyleID=\"wbTS\">");
            } else if (bl) {
                stringBuilder.append("  <Cell ss:StyleID=\"wbML\">");
            } else {
                stringBuilder.append("  <Cell>");
            }
            stringBuilder.append("<Data ss:Type=\"");
            stringBuilder.append(this.getDataType(rowData.getValue(i)));
            stringBuilder.append("\">");
            this.writeEscapedXML(stringBuilder, string);
            stringBuilder.append("</Data></Cell>\n");
        }
        stringBuilder.append("</Row>\n\n");
        return stringBuilder;
    }

    private String getDateFormat() {
        String string = this.defaultTimestampFormatter != null ? this.defaultTimestampFormatter.toPattern() : "yyyy\\-mm\\-dd\\ hh:mm:ss";
        String string2 = StringUtil.replace(string, "-", "\\-");
        string2 = StringUtil.replace(string2, " ", "\\ ");
        string2 = StringUtil.replace(string2, "/", "\\/");
        return string2.toLowerCase();
    }

    private String getDataType(Object object) {
        if (object instanceof Number) {
            return "Number";
        }
        if (object instanceof Date) {
            return "DateTime";
        }
        return "String";
    }
}

