/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import workbench.storage.DmlStatement;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;
import workbench.storage.StatementFactory;

public class Firebird20MergeGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("firebird");
    private StatementFactory stmtFactory;

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount() * 100);
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        StatementFactory statementFactory = new StatementFactory(resultInfo, rowDataContainer.getOriginalConnection());
        for (int i = 0; i < rowDataContainer.getRowCount(); ++i) {
            stringBuilder.append(this.generateUpsert(statementFactory, resultInfo, rowDataContainer.getRow(i)));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        this.stmtFactory = new StatementFactory(rowDataContainer.getResultInfo(), rowDataContainer.getOriginalConnection());
        return "";
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        if (this.stmtFactory == null) {
            this.stmtFactory = new StatementFactory(resultInfo, null);
        }
        return this.generateUpsert(this.stmtFactory, resultInfo, rowData);
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        this.stmtFactory = null;
        return "";
    }

    private String generateUpsert(StatementFactory statementFactory, ResultInfo resultInfo, RowData rowData) {
        DmlStatement dmlStatement = statementFactory.createInsertStatement(rowData, true, "\n");
        dmlStatement.setFormatSql(false);
        CharSequence charSequence = dmlStatement.getExecutableStatement(this.formatter);
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 50);
        stringBuilder.append("UPDATE OR ");
        stringBuilder.append(charSequence);
        stringBuilder.append("\nMATCHING (");
        int n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (!resultInfo.getColumn(i).isPkColumn()) continue;
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(resultInfo.getColumn(0).getColumnName());
        }
        stringBuilder.append(");");
        return stringBuilder.toString();
    }
}

