/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.DbMetadata;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.oracle.OraclePackageParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class FirebirdProcedureReader
extends JdbcProcedureReader {
    private boolean is30;
    private static final short SMALLINT_TYPE = 7;
    private static final short INTEGER_TYPE = 8;
    private static final short QUAD_TYPE = 9;
    private static final short FLOAT_TYPE = 10;
    private static final short D_FLOAT_TYPE = 11;
    private static final short DATE_TYPE = 12;
    private static final short TIME_TYPE = 13;
    private static final short CHAR_TYPE = 14;
    private static final short INT64_TYPE = 16;
    private static final short DOUBLE_TYPE = 27;
    private static final short TIMESTAMP_TYPE = 35;
    private static final short VARCHAR_TYPE = 37;
    private static final short BLOB_TYPE = 261;
    private static final short BOOLEAN_TYPE = 23;

    public FirebirdProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
        this.is30 = JdbcUtils.hasMinimumServerVersion(wbConnection, "3.0");
    }

    @Override
    public void readProcedureSource(ProcedureDefinition procedureDefinition, String string, String string2) throws NoConfigException {
        if (this.is30 && procedureDefinition.isPackageProcedure()) {
            CharSequence charSequence = this.getPackageSource(null, null, procedureDefinition.getPackageName());
            procedureDefinition.setSource(charSequence);
        } else {
            super.readProcedureSource(procedureDefinition, string, string2);
        }
    }

    @Override
    public DataStore buildProcedureListDataStore(DbMetadata dbMetadata, boolean bl) {
        DataStore dataStore = super.buildProcedureListDataStore(dbMetadata, bl);
        if (this.supportsPackages()) {
            dataStore.getResultInfo().getColumn(2).setColumnName("PACKAGE");
        }
        return dataStore;
    }

    @Override
    public boolean supportsPackages() {
        return this.is30;
    }

    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        if (!this.supportsPackages()) {
            return super.getProcedures(string, string2, string3);
        }
        return this.getProceduresAndPackages(string2, string3);
    }

    private DataStore getProceduresAndPackages(String string, String string2) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("select * \nfrom (  \n  select trim(rdb$package_name) as procedure_cat,   \n         null as procedure_schem,  \n         trim(rdb$procedure_name) as procedure_name,  \n         rdb$description as remarks,  \n         rdb$procedure_outputs as procedure_type  \n  from rdb$procedures  \n  where rdb$private_flag = 0 \n     or rdb$package_name is null \n  union all  \n  select trim(rdb$package_name),   \n         null as procedure_schem,  \n         trim(rdb$function_name),  \n         rdb$description as remarks,  \n         2 -- returns result \n  from rdb$functions \n  where rdb$private_flag = 0 \n     or rdb$package_name is null \n) t \n");
        string = DbMetadata.cleanupWildcards(string);
        string2 = DbMetadata.cleanupWildcards(string2);
        if (StringUtil.isNonEmpty(string2)) {
            SqlUtil.appendAndCondition(stringBuilder, "procedure_name", string2, this.connection);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedures", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            DataStore dataStore = this.fillProcedureListDataStore(resultSet);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                String string3 = dataStore.getValueAsString(i, 2);
                String string4 = dataStore.getValueAsString(i, 0);
                String string5 = dataStore.getValueAsString(i, 4);
                int n = dataStore.getValueAsInt(i, 1, 0);
                ProcedureDefinition procedureDefinition = new ProcedureDefinition(string4, n);
                procedureDefinition.setComment(string5);
                procedureDefinition.setPackageName(string3);
                dataStore.getRow(i).setUserObject(procedureDefinition);
            }
            dataStore.sort(FirebirdProcedureReader.getProcedureListSort());
            dataStore.resetStatus();
            return dataStore;
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "procedures", stringBuilder, new Object[0]);
            throw sQLException;
        }
    }

    @Override
    public StringBuilder getProcedureHeader(ProcedureDefinition procedureDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        try {
            DataStore dataStore = this.getProcedureColumns(procedureDefinition);
            stringBuilder.append("CREATE OR ALTER ");
            boolean bl = false;
            if (this.is30 && procedureDefinition.isFunction()) {
                stringBuilder.append("FUNCTION ");
                bl = true;
            } else {
                stringBuilder.append("PROCEDURE ");
            }
            stringBuilder.append(procedureDefinition.getProcedureName());
            String string = null;
            int n = dataStore.getRowCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = dataStore.getValueAsString(i, 2);
                String string3 = dataStore.getValueAsString(i, 0);
                String string4 = dataStore.getValueAsString(i, 1);
                if ("OUT".equals(string4)) {
                    if (string == null) {
                        string = "(" + string3 + " " + string2;
                        continue;
                    }
                    string = string + ", " + string3 + " " + string2;
                    continue;
                }
                if ("RETURN".equals(string4)) {
                    string = string2;
                    continue;
                }
                if (n2 > 0) {
                    stringBuilder.append(", ");
                } else {
                    stringBuilder.append(" (");
                }
                stringBuilder.append(string3);
                stringBuilder.append(' ');
                stringBuilder.append(string2);
                ++n2;
            }
            if (n2 > 0) {
                stringBuilder.append(')');
            }
            if (string != null) {
                stringBuilder.append("\n  RETURNS ");
                stringBuilder.append(string);
                if (!bl) {
                    stringBuilder.append(")");
                }
            }
            stringBuilder.append("\nAS\n");
        }
        catch (Exception exception) {
            stringBuilder = StringUtil.emptyBuilder();
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getPackageSource(String string, String string2, String string3) {
        StringBuilder stringBuilder;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            String string4 = "select rdb$package_header_source, rdb$package_body_source \nfrom rdb$packages \nwhere rdb$package_name = ? ";
            preparedStatement = null;
            resultSet = null;
            stringBuilder = new StringBuilder(500);
            DelimiterDefinition delimiterDefinition = Settings.getInstance().getAlternateDelimiter(this.connection, DelimiterDefinition.STANDARD_DELIMITER);
            try {
                preparedStatement = this.connection.getSqlConnection().prepareStatement(string4);
                preparedStatement.setString(1, string3);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                String string5 = resultSet.getString(1);
                stringBuilder.append("CREATE OR ALTER PACKAGE ");
                stringBuilder.append(this.connection.getMetadata().quoteObjectname(string3));
                stringBuilder.append("\nAS\n");
                stringBuilder.append(string5);
                stringBuilder.append(delimiterDefinition.getScriptText());
                stringBuilder.append('\n');
                String string6 = resultSet.getString(2);
                stringBuilder.append("RECREATE PACKAGE BODY ");
                stringBuilder.append(this.connection.getMetadata().quoteObjectname(string3));
                stringBuilder.append("\nAS\n");
                stringBuilder.append(string6);
                stringBuilder.append(delimiterDefinition.getScriptText());
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not retrieve package source using: \n" + SqlUtil.replaceParameters(string4, string3), sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder;
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        if (this.is30) {
            return this.retrieveProcedureColumns(procedureDefinition);
        }
        return super.getProcedureColumns(procedureDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore retrieveProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        String string = "select * \nfrom ( \n  select trim(pp.rdb$parameter_name) as column_name, \n         f.rdb$field_type as field_type, \n         f.rdb$field_sub_type as field_sub_type, \n         f.rdb$field_precision as field_precision, \n         f.rdb$field_scale as field_scale, \n         f.rdb$field_length as field_length, \n         case pp.rdb$parameter_type when 0 then 1 else 4 end as parameter_mode, \n         trim(pp.rdb$description) as remarks, \n         f.rdb$character_length as char_len, \n         pp.rdb$parameter_number + 1 as parameter_number,  \n" + (this.is30 ? "         trim(pp.rdb$package_name) as package_name,  \n" : "         null as package_name, \n") + "         trim(pp.rdb$procedure_name) as procedure_name,  \n         'procedure' as proc_type \n  from rdb$procedure_parameters pp \n    join rdb$fields f on pp.rdb$field_source = f.rdb$field_name \n  union all \n  select trim(fp.rdb$argument_name), \n         f.rdb$field_type, \n         f.rdb$field_sub_type, \n         f.rdb$field_precision, \n         f.rdb$field_scale, \n         f.rdb$field_length, \n         case when rdb$argument_name is null then " + 5 + " else " + 1 + " end, \n         trim(fp.rdb$description), \n         f.rdb$character_length, \n         fp.rdb$argument_position + 1,  \n" + (this.is30 ? "         trim(fp.rdb$package_name), \n" : "         null, \n") + "         trim(fp.rdb$function_name), \n         'function' as proc_type \n  from rdb$function_arguments fp \n    join rdb$fields f on fp.rdb$field_source = f.rdb$field_name \n) t \nwhere procedure_name = ? \n   and proc_type = ? \n";
        if (procedureDefinition.isPackageProcedure()) {
            string = string + "  and package_name = ? \n";
        }
        string = string + "order by parameter_number";
        String string2 = null;
        string2 = procedureDefinition.isFunction() ? "function" : "procedure";
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedure parameter", string, procedureDefinition.getProcedureName(), string2, procedureDefinition.getPackageName());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataStore dataStore = this.createProcColsDataStore();
        try {
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, procedureDefinition.getProcedureName());
            preparedStatement.setString(2, string2);
            if (procedureDefinition.isPackageProcedure()) {
                preparedStatement.setString(3, procedureDefinition.getPackageName());
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("column_name");
                short s = resultSet.getShort("field_type");
                short s2 = resultSet.getShort("field_sub_type");
                int n = resultSet.getInt("field_precision");
                short s3 = resultSet.getShort("field_scale");
                int n2 = resultSet.getInt("field_length");
                String string4 = resultSet.getString("remarks");
                int n3 = resultSet.getInt("parameter_number");
                int n4 = resultSet.getInt("parameter_mode");
                int n5 = dataStore.addRow();
                dataStore.setValue(n5, 0, (Object)string3);
                dataStore.setValue(n5, 1, (Object)this.convertArgModeToString(n4));
                dataStore.setValue(n5, 5, (Object)n3);
                int n6 = FirebirdProcedureReader.getDataType(s, s2, s3);
                dataStore.setValue(n5, 3, (Object)n6);
                String string5 = FirebirdProcedureReader.getDataTypeName(s, s2, s3);
                int n7 = 0;
                short s4 = 0;
                if (SqlUtil.isNumberType(n6)) {
                    n7 = n;
                    s4 = s3 == -1 ? (short)0 : s3;
                } else {
                    n7 = n2;
                    s4 = 0;
                }
                String string6 = this.connection.getMetadata().getDataTypeResolver().getSqlTypeDisplay(string5, n6, n7, s4);
                dataStore.setValue(n5, 2, (Object)string6);
                dataStore.setValue(n5, 4, (Object)string4);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedure parameter", string, procedureDefinition.getProcedureName(), string2, procedureDefinition.getPackageName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    @Override
    public CharSequence getPackageProcedureSource(ProcedureDefinition procedureDefinition) {
        if (!this.supportsPackages()) {
            return null;
        }
        if (procedureDefinition == null) {
            return null;
        }
        if (!procedureDefinition.isPackageProcedure()) {
            return null;
        }
        CharSequence charSequence = null;
        try {
            if (procedureDefinition.getSource() == null) {
                this.readProcedureSource(procedureDefinition, null, null);
            }
            if (procedureDefinition.getSource() != null) {
                charSequence = OraclePackageParser.getProcedureSource(procedureDefinition.getSource(), procedureDefinition, null);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read procedure source", exception);
        }
        return charSequence;
    }

    private static int getDataType(short s, short s2, short s3) {
        switch (s) {
            case 7: {
                if (s2 == 1 || s2 == 0 && s3 < 0) {
                    return 2;
                }
                if (s2 == 2) {
                    return 3;
                }
                return 5;
            }
            case 8: {
                if (s2 == 1 || s2 == 0 && s3 < 0) {
                    return 2;
                }
                if (s2 == 2) {
                    return 3;
                }
                return 4;
            }
            case 11: 
            case 27: {
                return 8;
            }
            case 10: {
                return 6;
            }
            case 14: {
                return 1;
            }
            case 37: {
                return 12;
            }
            case 35: {
                return 93;
            }
            case 13: {
                return 92;
            }
            case 12: {
                return 91;
            }
            case 16: {
                if (s2 == 1 || s2 == 0 && s3 < 0) {
                    return 2;
                }
                if (s2 == 2) {
                    return 3;
                }
                return -5;
            }
            case 261: {
                if (s2 < 0) {
                    return 2004;
                }
                if (s2 == 0) {
                    return -4;
                }
                if (s2 == 1) {
                    return -1;
                }
                return 1111;
            }
            case 9: {
                return 1111;
            }
            case 23: {
                return 16;
            }
        }
        return 0;
    }

    private static String getDataTypeName(short s, short s2, short s3) {
        switch (s) {
            case 7: {
                if (s2 == 1 || s2 == 0 && s3 < 0) {
                    return "NUMERIC";
                }
                if (s2 == 2) {
                    return "DECIMAL";
                }
                return "SMALLINT";
            }
            case 8: {
                if (s2 == 1 || s2 == 0 && s3 < 0) {
                    return "NUMERIC";
                }
                if (s2 == 2) {
                    return "DECIMAL";
                }
                return "INTEGER";
            }
            case 11: 
            case 27: {
                return "DOUBLE PRECISION";
            }
            case 10: {
                return "FLOAT";
            }
            case 14: {
                return "CHAR";
            }
            case 37: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 13: {
                return "TIME";
            }
            case 12: {
                return "DATE";
            }
            case 16: {
                if (s2 == 1 || s2 == 0 && s3 < 0) {
                    return "NUMERIC";
                }
                if (s2 == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 261: {
                if (s2 < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (s2 == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (s2 == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + s2;
            }
            case 9: {
                return "ARRAY";
            }
            case 23: {
                return "BOOLEAN";
            }
        }
        return "NULL";
    }
}

