/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.AbstractConstraintReader;
import workbench.db.DBID;

public class H2ConstraintReader
extends AbstractConstraintReader {
    private final String COLUMN_SQL = "select column_name constraint_name,        case when \n           check_constraint is not null and trim(check_constraint) <> '' then 'CHECK '||check_constraint \n           else null \n       end as check_constraint \nfrom information_schema.columns \nwhere table_name = ? \n  and table_schema = ?";
    private final String TABLE_SQL = "select constraint_name, \n       check_expression \nfrom information_schema.constraints \nwhere constraint_type = 'CHECK'  \nand table_name = ? \n and table_schema = ?";
    private Pattern systemNamePattern = Pattern.compile("^(CONSTRAINT_[0-9A-F][0-9A-F])");

    public H2ConstraintReader() {
        super(DBID.H2.getId());
    }

    @Override
    public int getIndexForSchemaParameter() {
        return 2;
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 1;
    }

    @Override
    public String getColumnConstraintSql() {
        return this.COLUMN_SQL;
    }

    @Override
    public String getTableConstraintSql() {
        return this.TABLE_SQL;
    }

    @Override
    public boolean isSystemConstraintName(String string) {
        Matcher matcher = this.systemNamePattern.matcher(string);
        return matcher.matches();
    }
}

