/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import workbench.db.TableIdentifier;
import workbench.storage.ColumnData;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;

public class H2MergeGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("ansi");

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateStart(stringBuilder, rowDataContainer, false);
        return stringBuilder.toString();
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (l > 0L) {
            stringBuilder.append(",\n  ");
        }
        stringBuilder.append('(');
        this.appendValues(stringBuilder, resultInfo, rowData);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        return ";\n";
    }

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount());
        this.generateStart(stringBuilder, rowDataContainer, true);
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    private void generateStart(StringBuilder stringBuilder, RowDataContainer rowDataContainer, boolean bl) {
        int n;
        int n2;
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        stringBuilder.append("MERGE INTO ");
        stringBuilder.append(tableIdentifier.getTableExpression(rowDataContainer.getOriginalConnection()));
        stringBuilder.append(" (");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        for (n2 = 0; n2 < resultInfo.getColumnCount(); ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(n2));
        }
        stringBuilder.append(")\n  KEY (");
        n2 = 0;
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (!resultInfo.getColumn(n).isPkColumn()) continue;
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(n));
            ++n2;
        }
        stringBuilder.append(")\nVALUES\n  ");
        if (bl) {
            for (n = 0; n < rowDataContainer.getRowCount(); ++n) {
                if (n > 0) {
                    stringBuilder.append(",\n  ");
                }
                stringBuilder.append('(');
                this.appendValues(stringBuilder, resultInfo, rowDataContainer.getRow(n));
                stringBuilder.append(')');
            }
        }
    }

    private void appendValues(StringBuilder stringBuilder, ResultInfo resultInfo, RowData rowData) {
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ColumnData columnData = new ColumnData(rowData.getValue(i), resultInfo.getColumn(i));
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
        }
    }
}

