/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class H2SequenceReader
implements SequenceReader {
    private WbConnection dbConnection;

    public H2SequenceReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return "";
        }
        return sequenceDefinition.getSource();
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        String string = dataStore.getValueAsString(n, "SEQUENCE_NAME");
        String string2 = dataStore.getValueAsString(n, "SEQUENCE_SCHEMA");
        sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setSequenceProperty("current_value", dataStore.getValue(n, "CURRENT_VALUE"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "INCREMENT"));
        sequenceDefinition.setSequenceProperty("is_generated", dataStore.getValue(n, "IS_GENERATED"));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "CACHE"));
        String string3 = dataStore.getValueAsString(n, "REMARKS");
        sequenceDefinition.setComment(string3);
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        Long l = (Long)sequenceDefinition.getSequenceProperty("increment");
        if (l != null && l != 1L) {
            stringBuilder.append("\n       INCREMENT BY ");
            stringBuilder.append(l);
        }
        stringBuilder.append("\n       CACHE ");
        stringBuilder.append(sequenceDefinition.getSequenceProperty("cache").toString());
        stringBuilder.append(';');
        stringBuilder.append(string);
        String string2 = sequenceDefinition.getComment();
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("\nCOMMENT ON SEQUENCE ");
            stringBuilder.append(sequenceDefinition.getSequenceName());
            stringBuilder.append(" IS '");
            stringBuilder.append(string2.replace("'", "''"));
            stringBuilder.append("';");
        }
        sequenceDefinition.setSource(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("SELECT SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, CURRENT_VALUE, INCREMENT, IS_GENERATED, REMARKS, ID,CACHE FROM information_schema.sequences ");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            if (!bl) {
                stringBuilder.append(" WHERE ");
                bl = true;
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(" sequence_schema = '" + string2 + "'");
        }
        if (StringUtil.isNonBlank(string3)) {
            if (!bl) {
                stringBuilder.append(" WHERE ");
                bl = true;
            } else {
                stringBuilder.append(" AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "sequence_name", string3, this.dbConnection);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        try {
            statement = this.dbConnection.createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence definition", stringBuilder, new Object[0]);
                dataStore = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

