/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import workbench.db.DBID;
import workbench.db.ViewGrantReader;
import workbench.db.WbConnection;

public class Db2ViewGrantReader
extends ViewGrantReader {
    private final DBID id;
    private final char catalogSeparator;

    public Db2ViewGrantReader(WbConnection wbConnection) {
        this.id = DBID.fromConnection(wbConnection);
        this.catalogSeparator = wbConnection.getMetadata().getCatalogSeparator();
    }

    @Override
    public String getViewGrantSql() {
        switch (this.id) {
            case DB2_ISERIES: {
                return this.getDB2iSQL();
            }
            case DB2_ZOS: {
                return this.getHostSQL();
            }
        }
        return this.getLUWSql();
    }

    private String getDB2iSQL() {
        return "select trim(grantee), \n       privilege_type as privilege, \n       is_grantable, \n       table_name, \n       table_schema \nfrom qsys2" + this.catalogSeparator + "systabauth \nwhere table_name = ?\n  and table_schema = ?";
    }

    private String getHostSQL() {
        return "select rtrim(grantee) as grantee, privilege, is_grantable  \nfrom ( \nselect grantee,  \n       'SELECT' as privilege,  \n       case selectauth \n         when 'G' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       ttname,  \n       tcreator \nfrom  sysibm.systabauth \nwhere selectauth in ('Y', 'G') \nUNION ALL \nselect grantee,  \n       'UPDATE' as privilege,  \n       case updateauth \n         when 'G' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       ttname,  \n       tcreator \nfrom  sysibm.systabauth \nwhere updateauth in ('Y', 'G') \nUNION ALL \nselect grantee,  \n       'DELETE' as privilege,  \n       case deleteauth \n         when 'G' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       ttname,  \n       tcreator \nfrom sysibm.systabauth \nwhere deleteauth in ('Y', 'G') \nUNION ALL \nselect grantee,  \n       'INSERT' as privilege,  \n       case insertauth \n         when 'G' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       ttname,  \n       tcreator \nfrom sysibm.systabauth \nwhere insertauth in ('Y', 'G') \n) t \nwhere ttname = ? and tcreator = ? ";
    }

    private String getLUWSql() {
        return "select trim(grantee) as grantee, privilege, is_grantable  \nfrom ( \nselect grantee,  \n       'SELECT' as privilege,  \n       case controlauth \n         when 'Y' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       tabname,  \n       tabschema \nfrom syscat.tabauth \nwhere selectauth = 'Y' \nUNION ALL \nselect grantee,  \n       'UPDATE' as privilege,  \n       case controlauth \n         when 'Y' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       tabname,  \n       tabschema \nfrom syscat.tabauth \nwhere updateauth = 'Y' \nUNION ALL \nselect grantee,  \n       'DELETE' as privilege,  \n       case controlauth \n         when 'Y' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       tabname,  \n       tabschema \nfrom syscat.tabauth \nwhere deleteauth = 'Y' \nUNION ALL \nselect grantee,  \n       'INSERT' as privilege,  \n       case controlauth \n         when 'Y' then 'YES' \n         else 'NO' \n       end as is_grantable, \n       tabname,  \n       tabschema \nfrom syscat.tabauth \nwhere insertauth = 'Y' \n) t \nwhere tabname = ? and tabschema = ? ";
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 1;
    }

    @Override
    public int getIndexForSchemaParameter() {
        return 2;
    }
}

