/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class InformixSequenceReader
implements SequenceReader {
    private WbConnection dbConn;

    public InformixSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() != 1) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        String string = dataStore.getValueAsString(n, "sequence_name");
        String string2 = dataStore.getValueAsString(n, "sequence_schema");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "start_val"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "min_val"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "max_val"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "inc_val"));
        sequenceDefinition.setSequenceProperty("cycle", StringUtil.stringToBool(dataStore.getValueAsString(n, "cycle")));
        sequenceDefinition.setSequenceProperty("ordered", StringUtil.stringToBool(dataStore.getValueAsString(n, "order")));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "cache"));
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        String string4 = this.dbConn.getDbSettings().getProperty("systemschema", "informix");
        TableIdentifier tableIdentifier = new TableIdentifier(string, string4, "systables");
        TableIdentifier tableIdentifier2 = new TableIdentifier(string, string4, "syssequences");
        String string5 = tableIdentifier.getFullyQualifiedName(this.dbConn);
        String string6 = tableIdentifier2.getFullyQualifiedName(this.dbConn);
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("select trim(t.tabname) as sequence_name, \n       trim(t.owner) as sequence_schema, \n       seq.start_val, \n       seq.inc_val, \n       seq.min_val, \n       seq.max_val, \n       seq.cycle, \n       seq.cache, \n       seq.order \n from ");
        stringBuilder.append(string6);
        stringBuilder.append(" seq \n   join ");
        stringBuilder.append(string5);
        stringBuilder.append(" t on seq.tabid = t.tabid");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(" WHERE t.owner = '" + string2 + "'");
            bl = true;
        }
        if (StringUtil.isNonBlank(string3)) {
            if (bl) {
                stringBuilder.append(" AND ");
            } else {
                stringBuilder.append(" WHERE ");
            }
            SqlUtil.appendExpression(stringBuilder, "t.tabname", string3, this.dbConn);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            statement = this.dbConn.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, this.dbConn, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence definition", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        return sequenceDefinition.getSource();
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        Number number = (Number)sequenceDefinition.getSequenceProperty("start_value");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("min_value");
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        Number number4 = (Number)sequenceDefinition.getSequenceProperty("increment");
        boolean bl = (Boolean)sequenceDefinition.getSequenceProperty("cycle");
        boolean bl2 = (Boolean)sequenceDefinition.getSequenceProperty("ordered");
        Number number5 = (Number)sequenceDefinition.getSequenceProperty("cache");
        stringBuilder.append(this.buildSequenceDetails(number, number2, number3, number4, bl, bl2, number5));
        stringBuilder.append(';');
        stringBuilder.append(string);
        sequenceDefinition.setSource(stringBuilder);
    }

    private CharSequence buildSequenceDetails(Number number, Number number2, Number number3, Number number4, boolean bl, boolean bl2, Number number5) {
        boolean bl3;
        boolean bl4;
        StringBuilder stringBuilder = new StringBuilder(30);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        if (number != null && number.longValue() > 0L) {
            stringBuilder.append(string + "       ");
            stringBuilder.append("START WITH ");
            stringBuilder.append(number);
        }
        stringBuilder.append(string + "      ");
        stringBuilder.append(" INCREMENT BY ");
        stringBuilder.append(number4);
        stringBuilder.append(string + "      ");
        boolean bl5 = bl4 = number2 != null && number2.longValue() != 1L;
        if (bl4) {
            stringBuilder.append(" MINVALUE ");
            stringBuilder.append(number2);
        } else {
            stringBuilder.append(" NOMINVALUE");
        }
        stringBuilder.append(string + "      ");
        boolean bl6 = bl3 = number3 != null && number3.longValue() != Long.MAX_VALUE;
        if (bl3) {
            stringBuilder.append(" MAXVALUE ");
            stringBuilder.append(number3);
        } else {
            stringBuilder.append(" NOMAXVALUE");
        }
        stringBuilder.append(string + "      ");
        if (bl) {
            stringBuilder.append(" CYCLE");
        } else {
            stringBuilder.append(" NOCYCLE");
        }
        stringBuilder.append(string + "      ");
        if (bl2) {
            stringBuilder.append(" ORDER");
        } else {
            stringBuilder.append(" NOORDER");
        }
        stringBuilder.append(string + "      ");
        if (number5 != null && number5.longValue() > 0L) {
            stringBuilder.append(" CACHE ");
            stringBuilder.append(number5.toString());
        } else {
            stringBuilder.append(" NOCACHE");
        }
        return stringBuilder;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

