/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.ValueStatement;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.VariablePool;
import workbench.storage.ColumnData;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.ConverterException;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;
import workbench.util.WbFile;

public class ConstantColumnValues {
    public static final String VAR_NAME_CURRENT_FILE_PATH = "_wb_import_file_path";
    public static final String VAR_NAME_CURRENT_FILE_NAME = "_wb_import_file_name";
    public static final String VAR_NAME_CURRENT_FILE_DIR = "_wb_import_file_dir";
    public static final String VAR_NAME_CURRENT_LINE = "_wb_import_line_number";
    private List<String> originalDefinition;
    private ValueConverter originalConverter;
    private TableIdentifier currentTable;
    private List<ColumnData> columnValues;
    private final Map<Integer, ValueStatement> selectStatements = new HashMap<Integer, ValueStatement>();
    private final Map<String, String> variables = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private boolean usesVariables;

    public ConstantColumnValues(List<String> list, WbConnection wbConnection, String string, ValueConverter valueConverter) throws SQLException, ConverterException {
        if (StringUtil.isNonEmpty(string)) {
            this.currentTable = new TableIdentifier(string, wbConnection);
            List<ColumnIdentifier> list2 = wbConnection.getMetadata().getTableColumns(this.currentTable, false);
            if (list2.isEmpty()) {
                throw new SQLException("Table \"" + string + "\" not found!");
            }
            this.init(list, list2, valueConverter);
        } else {
            this.originalDefinition = new ArrayList<String>(list);
            this.originalConverter = valueConverter;
        }
    }

    ConstantColumnValues(List<String> list, List<ColumnIdentifier> list2) throws SQLException, ConverterException {
        this.originalDefinition = new ArrayList<String>(list);
        this.originalConverter = new ValueConverter();
        this.init(list, list2, this.originalConverter);
    }

    protected final void init(List<String> list, List<ColumnIdentifier> list2, ValueConverter valueConverter) throws SQLException, ConverterException {
        this.usesVariables = false;
        this.columnValues = new ArrayList<ColumnData>(list.size());
        this.selectStatements.clear();
        this.variables.clear();
        Set<String> set = CollectionUtil.caseInsensitiveSet(VAR_NAME_CURRENT_FILE_DIR, VAR_NAME_CURRENT_FILE_NAME, VAR_NAME_CURRENT_FILE_PATH, VAR_NAME_CURRENT_LINE);
        for (String string : list) {
            int n = string.indexOf(61);
            if (n < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = StringUtil.trimToNull(string.substring(n + 1));
            ColumnIdentifier columnIdentifier = this.findColumn(list2, string2);
            if (columnIdentifier != null) {
                Object object = null;
                if (string3 == null) {
                    LogMgr.logWarning(new CallerInfo(){}, "Empty value for column '" + columnIdentifier + "' assumed as NULL");
                } else if (this.isLineNumber(string3) || string3.startsWith("${") || string3.startsWith("$@{")) {
                    object = string3;
                } else {
                    if (SqlUtil.isCharacterType(columnIdentifier.getDataType()) && string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'') {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    object = valueConverter.convertValue(string3, columnIdentifier.getDataType());
                }
                if (SqlUtil.isCharacterType(columnIdentifier.getDataType()) && StringUtil.isNonBlank(string3) && !this.usesVariables) {
                    this.usesVariables = VariablePool.getInstance().containsVariable(string3, set);
                }
                this.columnValues.add(new ColumnData(object, columnIdentifier));
                continue;
            }
            throw new SQLException("Column '" + string2 + "' not found in target table!");
        }
    }

    public void initFileVariables(TableIdentifier tableIdentifier, WbConnection wbConnection, File file) throws SQLException, ConverterException {
        Object object;
        this.variables.clear();
        if (file == null) {
            return;
        }
        if (this.columnValues == null && this.originalDefinition != null || !TableIdentifier.tablesAreEqual(this.currentTable, tableIdentifier, wbConnection)) {
            LogMgr.logDebug(new CallerInfo(){}, "Inititializing new table columns for table: " + tableIdentifier.getTableExpression());
            object = wbConnection.getMetadata().getTableColumns(tableIdentifier, false);
            this.init(this.originalDefinition, (List<ColumnIdentifier>)object, this.originalConverter);
            this.currentTable = tableIdentifier.createCopy();
        }
        LogMgr.logDebug(new CallerInfo(){}, "Inititializing variables for file: " + file.getAbsolutePath());
        object = new WbFile(file.getAbsoluteFile().getParent());
        this.variables.put(VAR_NAME_CURRENT_FILE_DIR, ((WbFile)object).getFullPath());
        WbFile wbFile = new WbFile(file);
        this.variables.put(VAR_NAME_CURRENT_FILE_PATH, wbFile.getFullPath());
        this.variables.put(VAR_NAME_CURRENT_FILE_NAME, wbFile.getName());
    }

    private ColumnIdentifier findColumn(List<ColumnIdentifier> list, String string) {
        for (ColumnIdentifier columnIdentifier : list) {
            if (!columnIdentifier.getColumnName().equalsIgnoreCase(string)) continue;
            return columnIdentifier;
        }
        return null;
    }

    public String getFunctionLiteral(int n) {
        if (!this.isFunctionCall(n)) {
            return null;
        }
        String string = (String)this.getValue(n);
        return string.substring(2, string.length() - 1);
    }

    public List<String> getInputColumnsForFunction(int n) {
        String string = this.getFunctionLiteral(n);
        if (string == null) {
            return null;
        }
        List<String> list = SqlUtil.getFunctionParameters(string);
        List<String> list2 = CollectionUtil.arrayList();
        for (String string2 : list) {
            String string3 = StringUtil.trimQuotes(string2);
            if (!string3.startsWith("$")) continue;
            list2.add(string3.substring(1));
        }
        return list2;
    }

    public ValueStatement getStatement(int n) {
        ValueStatement valueStatement = this.selectStatements.get(n);
        if (valueStatement == null) {
            if (!this.isSelectStatement(n)) {
                return null;
            }
            String string = (String)this.getValue(n);
            String string2 = string.substring(3, string.length() - 1);
            valueStatement = new ValueStatement(string2);
            LogMgr.logDebug(new CallerInfo(){}, "Query for constant value at position " + (n + 1) + " is: " + valueStatement);
            this.selectStatements.put(n, valueStatement);
        }
        return valueStatement;
    }

    public boolean isSelectStatement(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.startsWith("$@{") && string.endsWith("}");
        }
        return false;
    }

    public boolean isLineNumber(int n) {
        Object object = this.getValue(n);
        if (object instanceof String) {
            return this.isLineNumber((String)object);
        }
        return false;
    }

    private boolean isLineNumber(String string) {
        String string2 = VariablePool.getInstance().buildVarName(VAR_NAME_CURRENT_LINE, false);
        String string3 = string;
        return string3.toLowerCase().equals(string2);
    }

    public boolean isFunctionCall(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.startsWith("${") && string.endsWith("}");
        }
        return false;
    }

    public int getColumnCount() {
        if (this.columnValues == null) {
            if (this.originalDefinition == null) {
                return 0;
            }
            return this.originalDefinition.size();
        }
        return this.columnValues.size();
    }

    public ColumnIdentifier getColumn(int n) {
        return this.columnValues.get(n).getIdentifier();
    }

    public ColumnData getColumnData(int n) {
        return this.replaceVariables(this.columnValues.get(n));
    }

    public ColumnData getColumnData(String string) {
        for (ColumnData columnData : this.columnValues) {
            if (!columnData.getIdentifier().getColumnName().equalsIgnoreCase(string)) continue;
            return this.replaceVariables(columnData);
        }
        return null;
    }

    public Object getValue(int n) {
        ColumnData columnData = this.replaceVariables(this.columnValues.get(n));
        return columnData.getValue();
    }

    private ColumnData replaceVariables(ColumnData columnData) {
        if (columnData == null) {
            return null;
        }
        if (this.usesVariables && this.variables.size() > 0 && SqlUtil.isCharacterType(columnData.getIdentifier().getDataType())) {
            String string = (String)columnData.getValue();
            String string2 = VariablePool.getInstance().replaceAllParameters(string, this.variables);
            return columnData.createCopy(string2);
        }
        return columnData;
    }

    public boolean removeColumn(ColumnIdentifier columnIdentifier) {
        if (this.columnValues == null) {
            return false;
        }
        if (columnIdentifier == null) {
            return false;
        }
        int n = -1;
        for (int i = 0; i < this.columnValues.size(); ++i) {
            if (!this.columnValues.get(i).getIdentifier().equals(columnIdentifier)) continue;
            n = i;
            break;
        }
        if (n > -1) {
            this.columnValues.remove(n);
        }
        return n > -1;
    }

    public void setParameter(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        Object object = this.getValue(n2);
        if (!this.isFunctionCall(n2)) {
            preparedStatement.setObject(n, object);
        }
    }

    public void done() {
        for (ValueStatement valueStatement : this.selectStatements.values()) {
            if (valueStatement == null) continue;
            valueStatement.done();
        }
    }
}

