/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.importer.DataReceiver;
import workbench.db.importer.DefaultImportOptions;
import workbench.db.importer.DefaultTextImportOptions;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.ProducerFactory;
import workbench.db.importer.RowDataProducer;
import workbench.db.importer.StreamImporter;
import workbench.db.importer.TextImportOptions;
import workbench.interfaces.ImportFileParser;
import workbench.interfaces.Interruptable;
import workbench.interfaces.JobErrorHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.storage.RowData;
import workbench.util.ClipboardFile;
import workbench.util.MessageBuffer;

public class DataStoreImporter
implements DataReceiver,
Interruptable {
    private DataStore target;
    private RowDataProducer source;
    private RowActionMonitor rowMonitor;
    private JobErrorHandler errorHandler;
    private int currentRowNumber;

    public DataStoreImporter(DataStore dataStore, RowActionMonitor rowActionMonitor, JobErrorHandler jobErrorHandler) {
        this.target = dataStore;
        this.rowMonitor = rowActionMonitor;
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(0);
        }
        this.errorHandler = jobErrorHandler;
    }

    @Override
    public void processFile(StreamImporter streamImporter) throws SQLException, IOException {
    }

    public void startImport() {
        try {
            this.currentRowNumber = 0;
            this.source.start();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error ocurred during import", exception);
        }
    }

    @Override
    public boolean isTransactionControlEnabled() {
        return true;
    }

    @Override
    public void setTableList(List<TableIdentifier> list) {
    }

    @Override
    public void deleteTargetTables() throws SQLException {
    }

    @Override
    public void beginMultiTable() throws SQLException {
    }

    @Override
    public void endMultiTable() {
    }

    @Override
    public boolean getCreateTarget() {
        return false;
    }

    @Override
    public boolean shouldProcessNextRow() {
        return true;
    }

    @Override
    public void nextRowSkipped() {
    }

    public void importString(String string) {
        this.importString(string, "\t", "\"");
    }

    public void importString(String string, String string2, String string3) {
        ClipboardFile clipboardFile = new ClipboardFile(string);
        this.setImportOptions(clipboardFile, ProducerFactory.ImportType.Text, new DefaultImportOptions(), new DefaultTextImportOptions(string2, string3));
    }

    public void importString(String string, ImportOptions importOptions, TextImportOptions textImportOptions) {
        ClipboardFile clipboardFile = new ClipboardFile(string);
        this.setImportOptions(clipboardFile, ProducerFactory.ImportType.Text, importOptions, textImportOptions);
    }

    public void setImportOptions(File file, ProducerFactory.ImportType importType, ImportOptions importOptions, TextImportOptions textImportOptions) {
        ResultInfo resultInfo = this.target.getResultInfo();
        ProducerFactory producerFactory = new ProducerFactory(file);
        producerFactory.setTextOptions(textImportOptions);
        producerFactory.setGeneralOptions(importOptions);
        producerFactory.setType(importType);
        producerFactory.setTargetTable(resultInfo.getUpdateTable());
        producerFactory.setConnection(this.target.getOriginalConnection());
        this.source = producerFactory.getProducer();
        ((ImportFileParser)this.source).setIgnoreMissingColumns(true);
        try {
            List<ColumnIdentifier> list = Arrays.asList(resultInfo.getColumns());
            List<ColumnIdentifier> list2 = producerFactory.getFileColumns();
            producerFactory.setColumnMap(list2, list);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error setting import columns", exception);
        }
        this.source.setReceiver(this);
        this.source.setAbortOnError(false);
        this.source.setErrorHandler(this.errorHandler);
    }

    public MessageBuffer getMessage() {
        return this.source.getMessages();
    }

    @Override
    public void processRow(Object[] objectArray) throws SQLException {
        RowData rowData = new RowData(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            rowData.setValue(i, objectArray[i]);
        }
        this.target.addRow(rowData);
        ++this.currentRowNumber;
        if (this.rowMonitor != null) {
            this.rowMonitor.setCurrentRow(this.currentRowNumber, -1L);
        }
    }

    @Override
    public void recordRejected(String string, long l, Throwable throwable) {
    }

    @Override
    public void setTableCount(int n) {
    }

    @Override
    public void setCurrentTable(int n) {
    }

    @Override
    public void setTargetTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, File file) throws SQLException {
        if (list.size() != this.target.getColumnCount()) {
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(ResourceMgr.getString("ErrImportInvalidColumnStructure"));
            }
            throw new SQLException("Invalid column count");
        }
    }

    @Override
    public void tableImportFinished() throws SQLException {
    }

    @Override
    public void importFinished() {
    }

    @Override
    public void importCancelled() {
    }

    @Override
    public void tableImportError() {
    }

    @Override
    public void cancelExecution() {
        this.source.cancel();
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }
}

