/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import workbench.db.importer.ParsingEndedException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;

public class GenericXMLColumnDetector
extends DefaultHandler {
    private String rowTag;
    private List<String> columnNames = new ArrayList<String>();
    private final boolean useAttributes;
    private boolean collectTags;

    public GenericXMLColumnDetector(Reader reader, String string, boolean bl) throws IOException, SAXException {
        this.rowTag = string;
        this.useAttributes = bl;
        this.parseTableStructure(reader);
    }

    public List<String> getColumns() {
        return this.columnNames;
    }

    private void parseTableStructure(Reader reader) throws IOException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(reader);
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (ParserConfigurationException | ParsingEndedException exception) {
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SAXException sAXException) {
            LogMgr.logError(new CallerInfo(){}, "Error reading table structure", sAXException);
            throw sAXException;
        }
        finally {
            FileUtil.closeQuietely(reader);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(this.rowTag)) {
            this.collectTags = false;
            throw new ParsingEndedException();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(this.rowTag)) {
            if (this.useAttributes) {
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.columnNames.add(attributes.getQName(i));
                }
                throw new ParsingEndedException();
            }
            this.collectTags = true;
        } else if (this.collectTags) {
            this.columnNames.add(string3);
        }
    }
}

