/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.ColumnIdentifier;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.DmlExpressionBuilder;
import workbench.db.DmlExpressionType;
import workbench.db.JdbcUtils;
import workbench.db.QuoteHandler;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.ColumnFilter;
import workbench.db.importer.ConstantColumnValues;
import workbench.db.importer.ImportMode;
import workbench.db.importer.OverrideIdentityType;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ImportDMLStatementBuilder {
    private final WbConnection dbConn;
    private final TableIdentifier targetTable;
    private final List<ColumnIdentifier> targetColumns;
    private List<ColumnIdentifier> keyColumns;
    private final Set<String> upsertRequiresPK = CollectionUtil.caseInsensitiveSet(DBID.Cubrid.getId(), DBID.MySQL.getId(), DBID.HANA.getId(), DBID.H2.getId(), DBID.SQL_Anywhere.getId(), DBID.SQLite.getId());
    private final Set<String> ignoreRequiresPK = CollectionUtil.caseInsensitiveSet(DBID.Cubrid.getId(), DBID.MySQL.getId(), DBID.SQL_Anywhere.getId(), DBID.SQLite.getId());
    private final Map<String, String> columnExpressions = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private OverrideIdentityType overrideIdentity;

    ImportDMLStatementBuilder(WbConnection wbConnection, TableIdentifier tableIdentifier, List<ColumnIdentifier> list, ColumnFilter columnFilter, boolean bl) {
        this.dbConn = wbConnection;
        this.targetTable = tableIdentifier;
        this.targetColumns = this.createColumnList(list, columnFilter, bl);
    }

    public void setOverrideStrategy(OverrideIdentityType overrideIdentityType) {
        this.overrideIdentity = overrideIdentityType;
    }

    public void setColumnExpressions(Map<String, String> map) {
        this.columnExpressions.clear();
        if (map != null) {
            this.columnExpressions.putAll(map);
        }
    }

    boolean hasNativeInsertIgnore() {
        if (this.dbConn.getMetadata().isOracle() && JdbcUtils.hasMinimumServerVersion(this.dbConn, "11.2")) {
            return true;
        }
        if (this.dbConn.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(this.dbConn, "9.5")) {
            return true;
        }
        if (DBID.SQLite.isDB(this.dbConn)) {
            return true;
        }
        return DBID.SQL_Anywhere.isDB(this.dbConn) && JdbcUtils.hasMinimumServerVersion(this.dbConn, "10.0");
    }

    public static boolean supportsOverrideIdentity(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        return wbConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(wbConnection, "9.5");
    }

    public static boolean supportsInsertIgnore(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(wbConnection, "9.5")) {
            return true;
        }
        if (wbConnection.getMetadata().isOracle() && JdbcUtils.hasMinimumServerVersion(wbConnection, "11.2")) {
            return true;
        }
        if (wbConnection.getMetadata().isDB2LuW()) {
            return true;
        }
        if (wbConnection.getMetadata().isSqlServer() && SqlServerUtil.isSqlServer2008(wbConnection)) {
            return true;
        }
        if (DBID.DB2_ZOS.isDB(wbConnection) && JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0")) {
            return true;
        }
        if (DBID.Cubrid.isDB(wbConnection)) {
            return true;
        }
        if (wbConnection.getMetadata().isHsql() && JdbcUtils.hasMinimumServerVersion(wbConnection, "2.0")) {
            return true;
        }
        if (wbConnection.getMetadata().isMySql()) {
            return true;
        }
        if (DBID.SQLite.isDB(wbConnection)) {
            return true;
        }
        return DBID.SQL_Anywhere.isDB(wbConnection) && JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
    }

    public static boolean supportsUpsert(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(wbConnection, "9.5")) {
            return true;
        }
        if (wbConnection.getMetadata().isFirebird() && JdbcUtils.hasMinimumServerVersion(wbConnection, "2.1")) {
            return true;
        }
        if (wbConnection.getMetadata().isOracle()) {
            return true;
        }
        if (wbConnection.getMetadata().isDB2LuW()) {
            return true;
        }
        if (wbConnection.getMetadata().isSqlServer() && SqlServerUtil.isSqlServer2008(wbConnection)) {
            return true;
        }
        if (DBID.DB2_ZOS.isDB(wbConnection) && JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0")) {
            return true;
        }
        if (DBID.HANA.isDB(wbConnection)) {
            return true;
        }
        if (DBID.Cubrid.isDB(wbConnection)) {
            return true;
        }
        if (wbConnection.getMetadata().isHsql() && JdbcUtils.hasMinimumServerVersion(wbConnection, "2.0")) {
            return true;
        }
        if (wbConnection.getMetadata().isH2()) {
            return true;
        }
        if (wbConnection.getMetadata().isMySql()) {
            return true;
        }
        if (DBID.SQLite.isDB(wbConnection)) {
            return true;
        }
        return DBID.SQL_Anywhere.isDB(wbConnection) && JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
    }

    boolean supportsUpsert() {
        if (this.upsertRequiresPK.contains(this.dbConn.getDbId())) {
            boolean bl = this.hasRealPK();
            if (!bl) {
                LogMgr.logInfo(new CallerInfo(){}, "Cannot use upsert without a primary key.");
            }
            return bl;
        }
        return CollectionUtil.isNonEmpty(this.getKeyColumns()) && ImportDMLStatementBuilder.supportsUpsert(this.dbConn);
    }

    boolean isModeSupported(ImportMode importMode) {
        switch (importMode) {
            case insertIgnore: {
                if (this.ignoreRequiresPK.contains(this.dbConn.getDbId())) {
                    boolean bl = this.hasRealPK();
                    if (!bl) {
                        LogMgr.logInfo(new CallerInfo(){}, "Cannot use insertIgnore without a primary key.");
                    }
                    return bl;
                }
                return ImportDMLStatementBuilder.supportsInsertIgnore(this.dbConn);
            }
            case insertUpdate: 
            case updateInsert: 
            case upsert: {
                return this.supportsUpsert();
            }
        }
        return false;
    }

    void setKeyColumns(List<ColumnIdentifier> list) {
        this.keyColumns = new ArrayList<ColumnIdentifier>(2);
        if (list == null) {
            return;
        }
        for (ColumnIdentifier columnIdentifier : list) {
            this.keyColumns.add(columnIdentifier.createCopy());
        }
    }

    private QuoteHandler getQuoteHandler() {
        return this.dbConn == null ? QuoteHandler.STANDARD_HANDLER : this.dbConn.getMetadata();
    }

    private String getInsertString() {
        if (this.dbConn == null) {
            return null;
        }
        return this.dbConn.getDbSettings().getInsertForImport();
    }

    String createInsertStatement(ConstantColumnValues constantColumnValues, String string) {
        int n;
        DmlExpressionBuilder dmlExpressionBuilder = DmlExpressionBuilder.Factory.getBuilder(this.dbConn);
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50);
        StringBuilder stringBuilder2 = new StringBuilder(this.targetColumns.size() * 20);
        String string2 = StringUtil.firstNonBlank(string, this.getInsertString(), "INSERT INTO");
        stringBuilder.append(string2);
        stringBuilder.append(' ');
        stringBuilder.append(this.targetTable.getFullyQualifiedName(this.dbConn));
        stringBuilder.append(" (");
        QuoteHandler quoteHandler = this.getQuoteHandler();
        int n2 = 0;
        for (n = 0; n < this.getColCount(); ++n) {
            ColumnIdentifier columnIdentifier = this.targetColumns.get(n);
            if (n2 > 0) {
                stringBuilder.append(',');
                stringBuilder2.append(',');
            }
            String string3 = columnIdentifier.getDisplayName();
            string3 = quoteHandler.quoteObjectname(string3);
            stringBuilder.append(string3);
            String string4 = this.columnExpressions.get(string3);
            if (StringUtil.isNonBlank(string4)) {
                stringBuilder2.append(string4);
            } else {
                stringBuilder2.append(dmlExpressionBuilder.getDmlExpression(columnIdentifier, DmlExpressionType.Import));
            }
            ++n2;
        }
        if (constantColumnValues != null) {
            n = constantColumnValues.getColumnCount();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(',');
                stringBuilder.append(constantColumnValues.getColumn(i).getColumnName());
                stringBuilder2.append(',');
                if (constantColumnValues.isFunctionCall(i)) {
                    stringBuilder2.append(constantColumnValues.getFunctionLiteral(i));
                    continue;
                }
                stringBuilder2.append('?');
            }
        }
        stringBuilder.append(")\n");
        this.appendOverride(stringBuilder);
        stringBuilder.append("VALUES \n(");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private void appendOverride(StringBuilder stringBuilder) {
        if (this.overrideIdentity == null) {
            return;
        }
        switch (this.overrideIdentity) {
            case System: {
                stringBuilder.append("OVERRIDING SYSTEM VALUE \n");
                break;
            }
            case User: {
                stringBuilder.append("OVERRIDING USER VALUE \n");
            }
        }
    }

    String createInsertIgnore(ConstantColumnValues constantColumnValues, String string) {
        if (this.dbConn.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(this.dbConn, "9.5")) {
            return this.createPostgresUpsert(constantColumnValues, string, true);
        }
        if (this.dbConn.getMetadata().isMySql()) {
            return this.createMySQLUpsert(constantColumnValues, string, true);
        }
        if (DBID.Cubrid.isDB(this.dbConn)) {
            return this.createMySQLUpsert(constantColumnValues, string, true);
        }
        if (this.dbConn.getMetadata().isOracle()) {
            return this.createOracleInsertIgnore(constantColumnValues);
        }
        if (this.dbConn.getMetadata().isHsql()) {
            return this.createHSQLUpsert(constantColumnValues, true);
        }
        if (this.dbConn.getMetadata().isDB2LuW()) {
            return this.createDB2LuWUpsert(constantColumnValues, true);
        }
        if (DBID.DB2_ZOS.isDB(this.dbConn)) {
            return this.createDB2zOSUpsert(constantColumnValues, true);
        }
        if (this.dbConn.getMetadata().isSqlServer()) {
            return this.createSqlServerUpsert(constantColumnValues, true);
        }
        if (DBID.SQLite.isDB(this.dbConn)) {
            return this.createInsertStatement(constantColumnValues, "INSERT OR IGNORE ");
        }
        if (DBID.SQL_Anywhere.isDB(this.dbConn)) {
            return this.createSQLAnywhereStatement(constantColumnValues, true);
        }
        return null;
    }

    String createUpsertStatement(ConstantColumnValues constantColumnValues, String string) {
        if (this.dbConn.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(this.dbConn, "9.5")) {
            return this.createPostgresUpsert(constantColumnValues, string, false);
        }
        if (this.dbConn.getMetadata().isMySql()) {
            return this.createMySQLUpsert(constantColumnValues, string, false);
        }
        if (this.dbConn.getMetadata().isH2()) {
            return this.createH2Upsert(constantColumnValues);
        }
        if (this.dbConn.getMetadata().isHsql()) {
            return this.createHSQLUpsert(constantColumnValues, false);
        }
        if (this.dbConn.getMetadata().isFirebird()) {
            return this.createFirebirdUpsert(constantColumnValues);
        }
        if (this.dbConn.getMetadata().isDB2LuW()) {
            return this.createDB2LuWUpsert(constantColumnValues, false);
        }
        if (DBID.DB2_ZOS.isDB(this.dbConn)) {
            return this.createDB2zOSUpsert(constantColumnValues, false);
        }
        if (DBID.HANA.isDB(this.dbConn)) {
            return this.createHanaUpsert(constantColumnValues);
        }
        if (DBID.Cubrid.isDB(this.dbConn)) {
            return this.createMySQLUpsert(constantColumnValues, null, false);
        }
        if (this.dbConn.getMetadata().isSqlServer()) {
            return this.createSqlServerUpsert(constantColumnValues, false);
        }
        if (this.dbConn.getMetadata().isOracle()) {
            return this.createOracleMerge(constantColumnValues);
        }
        if (DBID.SQLite.isDB(this.dbConn)) {
            return this.createInsertStatement(constantColumnValues, "INSERT OR REPLACE ");
        }
        if (DBID.SQL_Anywhere.isDB(this.dbConn)) {
            return this.createSQLAnywhereStatement(constantColumnValues, false);
        }
        return null;
    }

    private String createSQLAnywhereStatement(ConstantColumnValues constantColumnValues, boolean bl) {
        String string = this.createInsertStatement(constantColumnValues, null);
        string = bl ? string.replace(") VALUES (", ") ON EXISTING SKIP VALUES (") : string.replace(") VALUES (", ") ON EXISTING UPDATE VALUES (");
        return string;
    }

    protected String createOracleInsertIgnore(ConstantColumnValues constantColumnValues) {
        String string = "INSERT /*+ IGNORE_ROW_ON_DUPKEY_INDEX (";
        string = string + this.targetTable.getRawTableName() + " (";
        List<ColumnIdentifier> list = this.getKeyColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            String string2 = list.get(i).getDisplayName();
            string = string + string2;
        }
        string = string + ")) */ INTO ";
        return this.createInsertStatement(constantColumnValues, string);
    }

    private String createHanaUpsert(ConstantColumnValues constantColumnValues) {
        if (CollectionUtil.isEmpty(this.getKeyColumns())) {
            return null;
        }
        String string = this.createInsertStatement(constantColumnValues, "UPSERT ");
        string = string + " WITH PRIMARY KEY";
        return string;
    }

    protected String createPostgresUpsert(ConstantColumnValues constantColumnValues, String string, boolean bl) {
        Object object;
        int n;
        if (CollectionUtil.isEmpty(this.getKeyColumns())) {
            return null;
        }
        String string2 = this.createInsertStatement(constantColumnValues, string);
        string2 = string2 + "\nON CONFLICT";
        if (bl) {
            string2 = string2 + "\nDO NOTHING";
            return string2;
        }
        QuoteHandler quoteHandler = this.getQuoteHandler();
        List<ColumnIdentifier> list = this.getKeyColumns();
        string2 = string2 + " (";
        for (n = 0; n < list.size(); ++n) {
            if (n > 0) {
                string2 = string2 + ",";
            }
            object = list.get(n).getDisplayName();
            object = quoteHandler.quoteObjectname((String)object);
            string2 = string2 + (String)object;
        }
        string2 = string2 + ")\nDO UPDATE\n  SET ";
        n = 0;
        object = this.getKeyColumns();
        for (int i = 0; i < this.targetColumns.size(); ++i) {
            ColumnIdentifier columnIdentifier = this.targetColumns.get(i);
            if (object.contains(columnIdentifier)) continue;
            if (n > 0) {
                string2 = string2 + ",\n      ";
            }
            String string3 = quoteHandler.quoteObjectname(columnIdentifier.getDisplayName());
            string2 = string2 + string3 + " = EXCLUDED." + string3;
            ++n;
        }
        return string2;
    }

    protected String createH2Upsert(ConstantColumnValues constantColumnValues) {
        String string = this.createInsertStatement(constantColumnValues, null);
        string = string.replace("INSERT INTO", "MERGE INTO");
        return string;
    }

    protected String createFirebirdUpsert(ConstantColumnValues constantColumnValues) {
        String string = this.createInsertStatement(constantColumnValues, null);
        string = string.replace("INSERT INTO", "UPDATE OR INSERT INTO");
        QuoteHandler quoteHandler = this.getQuoteHandler();
        List<ColumnIdentifier> list = this.getKeyColumns();
        if (CollectionUtil.isNonEmpty(list)) {
            string = string + "\nMATCHING (";
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                String string2 = list.get(i).getDisplayName();
                string2 = quoteHandler.quoteObjectname(string2);
                string = string + string2;
            }
            string = string + ")";
        }
        return string;
    }

    protected String createHSQLUpsert(ConstantColumnValues constantColumnValues, boolean bl) {
        return this.createStandardMerge(constantColumnValues, bl, "USING ");
    }

    protected String createDB2LuWUpsert(ConstantColumnValues constantColumnValues, boolean bl) {
        return this.createStandardMerge(constantColumnValues, bl, "USING TABLE");
    }

    protected String createDB2zOSUpsert(ConstantColumnValues constantColumnValues, boolean bl) {
        return this.createStandardMerge(constantColumnValues, bl, "USING ");
    }

    protected String createSqlServerUpsert(ConstantColumnValues constantColumnValues, boolean bl) {
        return this.createStandardMerge(constantColumnValues, bl, "USING ") + ";";
    }

    protected String createStandardMerge(ConstantColumnValues constantColumnValues, boolean bl, String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50);
        stringBuilder.append("MERGE INTO ");
        stringBuilder.append(this.targetTable.getFullyQualifiedName(this.dbConn));
        stringBuilder.append(" AS tg\n" + string + "(\n  VALUES (");
        QuoteHandler quoteHandler = this.getQuoteHandler();
        int n2 = 0;
        for (n = 0; n < this.getColCount(); ++n) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            if (constantColumnValues != null && constantColumnValues.isFunctionCall(n)) {
                stringBuilder.append(constantColumnValues.getFunctionLiteral(n));
            } else {
                stringBuilder.append('?');
            }
            ++n2;
        }
        stringBuilder.append(")\n) AS vals (");
        n2 = 0;
        for (n = 0; n < this.getColCount(); ++n) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            String string2 = this.targetColumns.get(n).getDisplayName();
            string2 = quoteHandler.quoteObjectname(string2);
            stringBuilder.append(string2);
            ++n2;
        }
        stringBuilder.append(")\n  ON ");
        n2 = 0;
        List<ColumnIdentifier> list = this.getKeyColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (n2 > 0) {
                stringBuilder.append(" AND ");
            }
            String string3 = list.get(i).getDisplayName();
            string3 = quoteHandler.quoteObjectname(string3);
            stringBuilder.append("tg.");
            stringBuilder.append(string3);
            stringBuilder.append(" = vals.");
            stringBuilder.append(string3);
            ++n2;
        }
        this.appendMergeMatchSection(stringBuilder, bl);
        return stringBuilder.toString();
    }

    private void appendMergeMatchSection(StringBuilder stringBuilder, boolean bl) {
        Comparable<ColumnIdentifier> comparable;
        QuoteHandler quoteHandler = this.getQuoteHandler();
        int n = 0;
        if (!bl) {
            stringBuilder.append("\nWHEN MATCHED THEN UPDATE\n  SET ");
            for (int i = 0; i < this.getColCount(); ++i) {
                comparable = this.targetColumns.get(i);
                if (this.isKeyColumn((ColumnIdentifier)comparable)) continue;
                String string = this.targetColumns.get(i).getDisplayName();
                string = quoteHandler.quoteObjectname(string);
                if (n > 0) {
                    stringBuilder.append(",\n      ");
                }
                stringBuilder.append("tg.");
                stringBuilder.append(string);
                stringBuilder.append(" = vals.");
                stringBuilder.append(string);
                ++n;
            }
        }
        StringBuilder stringBuilder2 = new StringBuilder(this.targetColumns.size() * 20);
        comparable = new StringBuilder(this.targetColumns.size() * 20);
        n = 0;
        for (int i = 0; i < this.getColCount(); ++i) {
            String string = this.targetColumns.get(i).getDisplayName();
            string = quoteHandler.quoteObjectname(string);
            if (n > 0) {
                stringBuilder2.append(", ");
                ((StringBuilder)comparable).append(", ");
            }
            stringBuilder2.append(string);
            ((StringBuilder)comparable).append("vals.");
            ((StringBuilder)comparable).append(string);
            ++n;
        }
        stringBuilder.append("\nWHEN NOT MATCHED THEN INSERT\n  (");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(")\nVALUES\n  (");
        stringBuilder.append((CharSequence)((Object)comparable));
        stringBuilder.append(")");
    }

    protected String createOracleMerge(ConstantColumnValues constantColumnValues) {
        StringBuilder stringBuilder = new StringBuilder(this.targetColumns.size() * 50);
        stringBuilder.append("MERGE INTO ");
        stringBuilder.append(this.targetTable.getFullyQualifiedName(this.dbConn));
        stringBuilder.append(" tg\n USING (\n  SELECT ");
        QuoteHandler quoteHandler = this.getQuoteHandler();
        int n = 0;
        for (int i = 0; i < this.getColCount(); ++i) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            if (constantColumnValues != null && constantColumnValues.isFunctionCall(i)) {
                stringBuilder.append(constantColumnValues.getFunctionLiteral(i));
            } else {
                stringBuilder.append('?');
            }
            String string = this.targetColumns.get(i).getDisplayName();
            stringBuilder.append(" AS ");
            stringBuilder.append(quoteHandler.quoteObjectname(string));
            ++n;
        }
        stringBuilder.append(" FROM DUAL\n) vals ON (");
        n = 0;
        List<ColumnIdentifier> list = this.getKeyColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (n > 0) {
                stringBuilder.append(" AND ");
            }
            String string = list.get(i).getDisplayName();
            string = quoteHandler.quoteObjectname(string);
            stringBuilder.append("tg.");
            stringBuilder.append(string);
            stringBuilder.append(" = vals.");
            stringBuilder.append(string);
            ++n;
        }
        stringBuilder.append(')');
        this.appendMergeMatchSection(stringBuilder, false);
        return stringBuilder.toString();
    }

    private boolean isKeyColumn(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier.isPkColumn()) {
            return true;
        }
        List<ColumnIdentifier> list = this.getKeyColumns();
        if (list != null) {
            return list.contains(columnIdentifier);
        }
        return false;
    }

    private String createMySQLUpsert(ConstantColumnValues constantColumnValues, String string, boolean bl) {
        String string2 = this.createInsertStatement(constantColumnValues, string);
        QuoteHandler quoteHandler = this.getQuoteHandler();
        string2 = string2 + "\nON DUPLICATE KEY UPDATE \n  ";
        if (bl) {
            String string3 = this.targetColumns.get(0).getDisplayName();
            string3 = quoteHandler.quoteObjectname(string3);
            string2 = string2 + " " + string3 + " = " + string3;
        } else {
            for (int i = 0; i < this.targetColumns.size(); ++i) {
                if (i > 0) {
                    string2 = string2 + ",\n  ";
                }
                String string4 = this.targetColumns.get(i).getDisplayName();
                string4 = quoteHandler.quoteObjectname(string4);
                string2 = string2 + string4 + " = VALUES(" + string4 + ")";
            }
        }
        return string2;
    }

    private List<ColumnIdentifier> getKeyColumns() {
        if (CollectionUtil.isEmpty(this.keyColumns)) {
            return this.getPKColumns();
        }
        return this.keyColumns;
    }

    private List<ColumnIdentifier> getPKColumns() {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(5);
        for (ColumnIdentifier columnIdentifier : this.targetColumns) {
            if (!columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }

    private boolean hasRealPK() {
        List<ColumnIdentifier> list = this.getKeyColumns();
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (ColumnIdentifier columnIdentifier : list) {
            if (columnIdentifier.isPkColumn()) continue;
            return false;
        }
        return true;
    }

    private int getColCount() {
        if (this.targetColumns == null) {
            return 0;
        }
        return this.targetColumns.size();
    }

    private List<ColumnIdentifier> createColumnList(List<ColumnIdentifier> list, ColumnFilter columnFilter, boolean bl) {
        DbMetadata dbMetadata = this.dbConn != null ? this.dbConn.getMetadata() : null;
        QuoteHandler quoteHandler = this.getQuoteHandler();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list.size());
        for (ColumnIdentifier columnIdentifier : list) {
            if (columnFilter != null && columnFilter.ignoreColumn(columnIdentifier)) continue;
            ColumnIdentifier columnIdentifier2 = columnIdentifier.createCopy();
            if (bl) {
                String string = quoteHandler.removeQuotes(columnIdentifier2.getColumnName());
                if (dbMetadata != null) {
                    string = dbMetadata.adjustObjectnameCase(string);
                }
                columnIdentifier2.setColumnName(string);
            }
            arrayList.add(columnIdentifier2);
        }
        return arrayList;
    }
}

