/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer.modifier;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import workbench.db.ColumnIdentifier;
import workbench.db.importer.modifier.ImportValueModifier;

public class RegexModifier
implements ImportValueModifier {
    public Map<ColumnIdentifier, RegexDef> limits = new HashMap<ColumnIdentifier, RegexDef>();

    @Override
    public int getSize() {
        return this.limits.size();
    }

    public void addDefinition(ColumnIdentifier columnIdentifier, String string, String string2) throws PatternSyntaxException {
        RegexDef regexDef = new RegexDef(string, string2);
        this.limits.put(columnIdentifier.createCopy(), regexDef);
    }

    @Override
    public String modifyValue(ColumnIdentifier columnIdentifier, String string) {
        if (string == null) {
            return null;
        }
        RegexDef regexDef = this.limits.get(columnIdentifier);
        if (regexDef != null) {
            Matcher matcher = regexDef.regex.matcher(string);
            return matcher.replaceAll(regexDef.replacement);
        }
        return string;
    }

    private static class RegexDef {
        Pattern regex;
        String replacement;

        public RegexDef(String string, String string2) throws PatternSyntaxException {
            this.regex = Pattern.compile(string);
            this.replacement = string2;
        }
    }
}

