/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;

public class SqlServerObjectListEnhancer
implements ObjectListEnhancer {
    static final String REMARKS_PROP_NAME = "remarks.propertyname";
    static final String REMARKS_PROP_DEFAULT = "MS_DESCRIPTION";

    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (wbConnection.getDbSettings().getBoolProperty("remarks.object.retrieve", true)) {
            this.updateObjectRemarks(wbConnection, dataStore, string, string2, string3, stringArray);
        }
    }

    protected void updateObjectRemarks(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (dataStore == null) {
            return;
        }
        if (dataStore.getRowCount() == 0) {
            return;
        }
        String string4 = null;
        if (dataStore.getRowCount() == 1) {
            string4 = dataStore.getValueAsString(0, 0);
            stringArray = new String[]{dataStore.getValueAsString(0, 1)};
        }
        Map<String, String> map = this.readRemarks(wbConnection, string2, string4, stringArray);
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string5 = dataStore.getValueAsString(i, 0);
            String string6 = dataStore.getValueAsString(i, 3);
            String string7 = map.get(string6 + "." + string5);
            if (string7 == null) continue;
            dataStore.setValue(i, 4, (Object)string7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readRemarks(WbConnection wbConnection, String string, String string2, String[] stringArray) {
        String string3 = wbConnection.getDbSettings().getProperty(REMARKS_PROP_NAME, REMARKS_PROP_DEFAULT);
        String string4 = null;
        if ("*".equals(string)) {
            string = null;
        }
        string4 = SqlServerUtil.isSqlServer2005(wbConnection) ? "SELECT objtype, objname, cast(value as varchar(8000)) as value \nFROM fn_listextendedproperty ('" + string3 + "','schema', ?, ?, " : "SELECT objtype, objname, cast(value as varchar(8000)) as value \nFROM ::fn_listextendedproperty ('" + string3 + "','user', ?, ?, ";
        string4 = string2 == null ? string4 + "null, null, null)" : string4 + "'" + string2 + "', null, null)";
        if (stringArray == null) {
            stringArray = new String[]{"TABLE", "VIEW", "SYNONYM", "TYPE", "RULE"};
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (string == null) {
            string = wbConnection.getMetadata().getCurrentSchema();
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
        String string5 = null;
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string6;
                string5 = string6 = stringArray2[i];
                LogMgr.logMetadataSql(new CallerInfo(){}, "table remarks", string4, string, string5);
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
                if (string == null) {
                    preparedStatement.setNull(1, 12);
                } else {
                    preparedStatement.setString(1, string);
                }
                preparedStatement.setString(2, string5);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string7 = resultSet.getString(2);
                    String string8 = resultSet.getString(3);
                    if (string7 == null || string8 == null) continue;
                    treeMap.put(string + "." + string7.trim(), string8);
                }
                JdbcUtils.closeResult(resultSet);
            }
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "table remarks", string4, string, string5);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        return treeMap;
    }
}

