/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import workbench.db.JdbcProcedureReader;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.mssql.SpHelpTextRunner;
import workbench.db.mssql.SqlServerObjectListEnhancer;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class SqlServerProcedureReader
extends JdbcProcedureReader {
    public SqlServerProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        DataStore dataStore = super.getProcedures(string, string2, string3);
        this.updateRemarks(dataStore, string2);
        return dataStore;
    }

    @Override
    protected Integer getProcedureType(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("PROCEDURE_NAME");
        return this.getProcTypeFromName(string);
    }

    private Integer getProcTypeFromName(String string) {
        int n = this.getProcGroupNumber(string);
        Integer n2 = n == 0 ? Integer.valueOf(2) : Integer.valueOf(1);
        return n2;
    }

    private int getProcGroupNumber(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(59);
        if (n < 1) {
            return 1;
        }
        return StringUtil.getIntValue(string.substring(n + 1), -1);
    }

    protected void updateRemarks(DataStore dataStore, String string) {
        if (!this.connection.getDbSettings().getBoolProperty("remarks.procedure.retrieve", false)) {
            return;
        }
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return;
        }
        String string2 = null;
        if (dataStore.getRowCount() == 1) {
            string2 = dataStore.getValueAsString(0, 0);
        }
        SqlServerObjectListEnhancer sqlServerObjectListEnhancer = new SqlServerObjectListEnhancer();
        Map<String, String> map = sqlServerObjectListEnhancer.readRemarks(this.connection, string, string2, new String[]{"procedure"});
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string3 = dataStore.getValueAsString(i, 3);
            String string4 = dataStore.getValueAsString(i, 0);
            String string5 = map.get(string3 + "." + string4);
            if (string5 == null) continue;
            dataStore.setValue(i, 4, (Object)string5);
        }
    }

    @Override
    public CharSequence retrieveProcedureSource(ProcedureDefinition procedureDefinition) throws NoConfigException {
        SpHelpTextRunner spHelpTextRunner = new SpHelpTextRunner();
        String string = this.stripProcGroupInfo(procedureDefinition.getProcedureName());
        CharSequence charSequence = spHelpTextRunner.getSource(this.connection, procedureDefinition.getCatalog(), procedureDefinition.getSchema(), string);
        return charSequence;
    }
}

