/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.ResultSet;
import java.sql.Statement;
import workbench.db.JdbcUtils;
import workbench.db.SchemaInformationReader;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class SqlServerSchemaInfoReader
implements SchemaInformationReader {
    private final WbConnection dbConnection;
    private String defaultSchema;
    private boolean schemaRetrieved;

    public SqlServerSchemaInfoReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.retrieveCurrentSchema();
    }

    private void retrieveCurrentSchema() {
        this.schemaRetrieved = false;
        if (JdbcUtils.hasMiniumDriverVersion(this.dbConnection, "4.2") && SqlServerUtil.isMicrosoftDriver(this.dbConnection)) {
            try {
                this.defaultSchema = this.dbConnection.getSqlConnection().getSchema();
                this.schemaRetrieved = true;
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Error retrieving current schema using getSchema(): " + throwable.getMessage());
            }
        }
        if (!this.schemaRetrieved) {
            this.defaultSchema = this.retrieveSchema(this.dbConnection);
            this.schemaRetrieved = true;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Using current schema: " + this.defaultSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveSchema(WbConnection wbConnection) {
        ResultSet resultSet;
        Statement statement;
        String string;
        block4: {
            string = null;
            String string2 = "SELECT schema_name()";
            statement = null;
            resultSet = null;
            try {
                statement = wbConnection.getSqlConnection().createStatement(1003, 1007);
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next()) break block4;
                string = resultSet.getString(1);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not obtain default schema using: \n" + string2, exception);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return string;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void clearCache() {
        this.defaultSchema = null;
    }

    @Override
    public String getCachedSchema() {
        return this.defaultSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() {
        if (!this.schemaRetrieved) {
            WbConnection wbConnection = this.dbConnection;
            synchronized (wbConnection) {
                this.retrieveCurrentSchema();
            }
        }
        return this.defaultSchema;
    }

    @Override
    public void dispose() {
    }
}

