/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.JdbcUtils;
import workbench.db.SequenceAdjuster;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class SqlServerSequenceAdjuster
implements SequenceAdjuster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int adjustTableSequences(WbConnection wbConnection, TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        String string = this.getIdentityColumn(tableIdentifier, wbConnection);
        if (string == null) {
            return 0;
        }
        long l = this.getMaxValue(tableIdentifier, string, wbConnection);
        if (l < 0L) {
            return 0;
        }
        Statement statement = null;
        String string2 = null;
        try {
            statement = wbConnection.getSqlConnection().createStatement();
            String string3 = tableIdentifier.getTableExpression(wbConnection);
            string2 = "dbcc checkident ('" + string3 + "', RESEED, " + l + ")";
            statement.execute(string2);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not reseed identity column using:\n" + string2, exception);
            int n = 0;
            return n;
        }
        finally {
            JdbcUtils.close((AutoCloseable)statement);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxValue(TableIdentifier tableIdentifier, String string, WbConnection wbConnection) {
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            if (string == null) {
                return -1L;
            }
            String string2 = "select max(" + wbConnection.getMetadata().quoteObjectname(string) + ") from " + tableIdentifier.getTableExpression(wbConnection);
            LogMgr.logMetadataSql(new CallerInfo(){}, "max identity value", string2, new Object[0]);
            preparedStatement = null;
            resultSet = null;
            l = -1L;
            try {
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string2);
                preparedStatement.setString(1, tableIdentifier.getRawSchema());
                preparedStatement.setString(2, tableIdentifier.getRawTableName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                l = resultSet.getLong(1);
                if (!resultSet.wasNull()) break block5;
                l = 0L;
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "max identity value", string2, new Object[0]);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.close(resultSet, preparedStatement);
            }
        }
        JdbcUtils.close(resultSet, preparedStatement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIdentityColumn(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        String string;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            String string2 = "select COLUMN_NAME \nfrom INFORMATION_SCHEMA.COLUMNS \nwhere COLUMNPROPERTY(object_id(TABLE_SCHEMA+'.'+TABLE_NAME), COLUMN_NAME, 'IsIdentity') = 1 \n  and TABLE_SCHEMA = ? \n  and TABLE_NAME = ? \n";
            LogMgr.logMetadataSql(new CallerInfo(){}, "identity column", string2, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            preparedStatement = null;
            resultSet = null;
            string = null;
            try {
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string2);
                preparedStatement.setString(1, tableIdentifier.getRawSchema());
                preparedStatement.setString(2, tableIdentifier.getRawTableName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                string = resultSet.getString(1);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "identity column", string2, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.close(resultSet, preparedStatement);
            }
        }
        JdbcUtils.close(resultSet, preparedStatement);
        return string;
    }
}

