/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.db.mysql.MySQLColumnCollationReader;
import workbench.db.mysql.MySQLEnumReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class MySQLColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        MySQLColumnCollationReader mySQLColumnCollationReader = new MySQLColumnCollationReader();
        mySQLColumnCollationReader.readCollations(tableDefinition, wbConnection);
        MySQLEnumReader mySQLEnumReader = new MySQLEnumReader();
        mySQLEnumReader.readEnums(tableDefinition, wbConnection);
        this.updateComputedColumns(tableDefinition, wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComputedColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "5.7") && !wbConnection.getMetadata().isMariaDB();
        String string = "select column_name,        extra, \n       " + (bl ? "generation_expression " : "null as generation_expression ") + " \nfrom information_schema.columns \nwhere table_schema = ?\n  and table_name = ? \n ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "column information", string, tableDefinition.getTable().getRawCatalog(), tableDefinition.getTable().getRawTableName());
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableDefinition.getTable().getRawCatalog());
            preparedStatement.setString(2, tableDefinition.getTable().getRawTableName());
            resultSet = preparedStatement.executeQuery();
            List<ColumnIdentifier> list = tableDefinition.getColumns();
            while (resultSet.next()) {
                String string2;
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string3);
                if (columnIdentifier == null) continue;
                string4 = this.trimKeyWords(string4, "GENERATED", "DEFAULT_GENERATED");
                if (StringUtil.isNonBlank(string5)) {
                    string2 = "GENERATED ALWAYS AS (" + string5 + ") " + string4;
                    columnIdentifier.setComputedColumnExpression(string2);
                    continue;
                }
                if (string4 != null && string4.toLowerCase().startsWith("on update")) {
                    string2 = columnIdentifier.getDefaultValue();
                    if (string2 == null) {
                        columnIdentifier.setDefaultValue(string4);
                        continue;
                    }
                    string2 = string2 + " " + string4;
                    columnIdentifier.setDefaultValue(string2);
                    continue;
                }
                if (!StringUtil.equalStringIgnoreCase(string4, "INVISIBLE")) continue;
                columnIdentifier.setSQLOption(string4);
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "column information", string, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
    }

    private String trimKeyWords(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        if (StringUtil.isBlank(string)) {
            return string;
        }
        string = string.trim();
        for (String string2 : stringArray) {
            if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue;
            return string.substring(string2.length() + 1);
        }
        return string;
    }
}

