/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.nuodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class NuoDBSequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private String baseQuery;

    public NuoDBSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.baseQuery = "SELECT schema, \n       sequencename\n FROM system.sequences";
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        CharSequence charSequence = this.getSequenceSource(sequenceDefinition.getCatalog(), sequenceDefinition.getSequenceOwner(), sequenceDefinition.getSequenceName());
        sequenceDefinition.setSource(charSequence);
    }

    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.baseQuery.length() + 20);
        stringBuilder.append(this.baseQuery);
        boolean bl = false;
        if (StringUtil.isNonBlank(string3)) {
            bl = true;
            stringBuilder.append(" WHERE ");
            SqlUtil.appendExpression(stringBuilder, "SEQUENCENAME", StringUtil.trimQuotes(string3), this.dbConn);
        }
        if (StringUtil.isNonBlank(string2)) {
            if (!bl) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "SCHEMA", StringUtil.trimQuotes(string2), null);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequences", stringBuilder, new Object[0]);
        DataStore dataStore = null;
        try {
            dataStore = SqlUtil.getResultData(this.dbConn, stringBuilder.toString(), false);
        }
        catch (Throwable throwable) {
            LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequences", stringBuilder, new Object[0]);
        }
        return dataStore;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        String string = dataStore.getValueAsString(n, "SEQUENCENAME");
        String string2 = dataStore.getValueAsString(n, "SCHEMA");
        sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        return this.buildSource(sequenceDefinition);
    }

    protected CharSequence buildSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(SqlUtil.buildExpression(this.dbConn, null, sequenceDefinition.getSchema(), sequenceDefinition.getSequenceName()));
        stringBuilder.append(';');
        return stringBuilder;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

