/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import workbench.db.JdbcUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class DbmsOutput {
    private Connection conn;
    private boolean enabled = false;
    private long lastSize;
    private final boolean useGetLines;

    public DbmsOutput(Connection connection) throws SQLException {
        this.conn = connection;
        this.useGetLines = JdbcUtils.hasMinimumServerVersion(this.conn, "11.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(long l) throws SQLException {
        if (this.enabled && l == this.lastSize) {
            return;
        }
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.conn.prepareCall("{call dbms_output.enable(?) }");
            if (l <= 0L) {
                callableStatement.setNull(1, -5);
            } else {
                callableStatement.setLong(1, l);
            }
            callableStatement.executeUpdate();
            this.enabled = true;
            this.lastSize = l;
            LogMgr.logDebug(new CallerInfo(){}, "Support for DBMS_OUTPUT package enabled (max size=" + (l > 0L ? Long.toString(l) : "unlimited") + ")");
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(callableStatement);
            throw throwable;
        }
        JdbcUtils.closeStatement(callableStatement);
    }

    public void disable() throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.conn.prepareCall("{call dbms_output.disable}");
            callableStatement.executeUpdate();
            this.enabled = false;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(callableStatement);
            throw throwable;
        }
        JdbcUtils.closeStatement(callableStatement);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getResult() throws SQLException {
        if (!this.enabled) {
            return "";
        }
        return this.retrieveOutput();
    }

    public String retrieveOutput() throws SQLException {
        if (this.useGetLines) {
            return this.retrieveUsingGetLines();
        }
        return this.retrieveUsingGetLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveUsingGetLines() throws SQLException {
        CallableStatement callableStatement = null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        Array array = null;
        try {
            callableStatement = this.conn.prepareCall("{call dbms_output.get_lines(?,?)}");
            callableStatement.registerOutParameter(1, 2003, "DBMSOUTPUT_LINESARRAY");
            callableStatement.registerOutParameter(2, 4);
            callableStatement.setInt(2, 100);
            callableStatement.execute();
            int n = callableStatement.getInt(2);
            while (n > 0) {
                array = callableStatement.getArray(1);
                Object[] objectArray = (Object[])array.getArray();
                int n2 = Math.min(n, objectArray.length);
                for (int i = 0; i < n2; ++i) {
                    String string = (String)objectArray[i];
                    stringBuilder.append(StringUtil.rtrim(StringUtil.coalesce(string, "")));
                    stringBuilder.append('\n');
                }
                callableStatement.execute();
                n = callableStatement.getInt(2);
            }
        }
        finally {
            try {
                if (array != null) {
                    array.free();
                }
            }
            catch (Throwable throwable) {}
            JdbcUtils.closeStatement(callableStatement);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveUsingGetLine() throws SQLException {
        CallableStatement callableStatement = null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            callableStatement = this.conn.prepareCall("{call dbms_output.get_line(?,?)}");
            callableStatement.registerOutParameter(1, 12);
            callableStatement.registerOutParameter(2, 2);
            int n = 0;
            while (n == 0) {
                callableStatement.execute();
                String string = callableStatement.getString(1);
                if (string == null) {
                    string = "";
                }
                if ((n = callableStatement.getInt(2)) != 0) continue;
                stringBuilder.append(StringUtil.rtrim(string));
                stringBuilder.append('\n');
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(callableStatement);
            throw throwable;
        }
        JdbcUtils.closeStatement(callableStatement);
        return stringBuilder.toString();
    }

    public void close() {
        try {
            this.disable();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when disabling dbms_output", throwable);
        }
    }
}

